/**
 * Project Name:goods-center-biz
 * File Name:PcgDirectionalSalesVolumeServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.stock.impl
 * Date:2016年8月3日下午6:04:58
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.stock.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.service.stock.PcgDirectionalSalesVolumeService;
import cn.com.duiba.stock.service.api.constant.SaleLimitTypes;
import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:PcgDirectionalSalesVolumeServiceImpl <br/>
 * Date:     2016年8月3日 下午6:04:58 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("pcgDirectionalSalesVolumeService")
public class PcgDirectionalSalesVolumeServiceImpl implements PcgDirectionalSalesVolumeService{
    @Autowired
    private RemoteSaleLimitService remoteSaleLimitService;
    @Override
    public Long findSaleCountToday(long pcgId, long directionId) {
        DubboResult<Long> todaySales=remoteSaleLimitService.findSaleCountToday(SaleLimitTypes.PcgDirectionalDayLimit, pcgId+"-"+directionId);
        if(!todaySales.isSuccess()){
            return Long.MAX_VALUE;
        }
        return todaySales.getResult();
    }

    @Override
    public boolean addSaleToday(long pcgId, long directionId, String orderNum, int dayLimit) {
        DubboResult<Boolean> ret=remoteSaleLimitService.addSaleToday(SaleLimitTypes.PcgDirectionalDayLimit, pcgId+"-"+directionId, orderNum, dayLimit);
        if(!ret.isSuccess() || !ret.getResult()){
            return false;
        }
        return true;
    }

    @Override
    public boolean rollbackSale(long pcgId, long directionId, String orderNum) {
        DubboResult<Boolean> ret=remoteSaleLimitService.rollbackSaleToday(SaleLimitTypes.PcgDirectionalDayLimit, pcgId+"-"+directionId, orderNum);
        if(!ret.isSuccess() || !ret.getResult()){
            return false;
        }
        return true;
    }

}

