package cn.com.duiba.goods.center.biz.bo.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.constant.PlatformCouponGoodsConstant;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

import com.alibaba.dubbo.common.utils.StringUtils;
@Service
public class PCGFilterConfigBOImpl implements PCGFilterConfigBO{
    public static class PCGIdAndPayLoad{
        public PCGIdAndPayLoad(){
            
        }
        public PCGIdAndPayLoad(Long pcgId,Integer payLoad){
            this.pagId = pcgId;
            this.payLoad = payLoad;
        }
        private Long pagId;
        private Integer payLoad;
        public Long getPagId() {
            return pagId;
        }
        public Integer getPayLoad() {
            return payLoad;
        }
        
        
    }

    @Autowired
    private PCGFilterConfigService        pCGFilterConfigService;
    @Autowired
    private PCGCategoryGoodsService       pCGCategoryGoodsService;
    @Autowired
    private PCGSellerGoodsService         pCGSellerGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private PlatformCouponGoodsService    platformCouponGoodsService;
    @Autowired
    protected GoodsBatchService           goodsBatchService;
    @Autowired
    protected RemoteAppService            remoteAppService;
    @Autowired
    protected RemoteStockBackendService   remoteStockBackendService;
    @Autowired
    protected GoodsLimitRecordService     goodsLimitRecordService;
    @Autowired
    protected GoodsBatchCouponBackendBO   goodsBatchCouponBackendBO;
    private SimpleDateFormat              sdf  = new SimpleDateFormat("yyyy.MM.dd");
    private SimpleDateFormat              sdf2 = new SimpleDateFormat("yyyyMMdd");

    public List<Long> filterGoods(List<Long> pcgIds, Long appId) {
        List<Long> filterGoodsIds = pCGFilterConfigService.selectPCGFilterTargetIds(appId,
                                                                                    PlatformCouponGoodsConstant.PcgFilterConfigGoodsType);
        if (!filterGoodsIds.isEmpty()) {
            Iterator<Long> ps = pcgIds.iterator();
            while (ps.hasNext()) {
                Long pcgId = ps.next();
                for (Long filterGoodsId : filterGoodsIds) {
                    // 当前商品被屏蔽，清除
                    if ((pcgId - filterGoodsId) == 0) {
                        ps.remove();
                    }
                }
            }
        }
        return pcgIds;
    }
    
    @Override
    public Page<PCGCategorySellerGoodsDto> findCategoryGoods(long appId, long categoryId, Long consumerId,
                                                             Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        // 1.查询该类目下的所有商品
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = pCGCategoryGoodsService.findAllGoodsByCategory(categoryId);
        
        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }

        // 2.商品进行单品黑名单过滤
        pcgIds = checkBlack(pcgIds, appId);
        // 4.放入商品信息
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        if (pcgIds !=null && !pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }

    /**
     * set排序号
     * 
     * @param pCGCategoryGoodsEntity
     * @param p
     * @return
     */
    public static Integer setPayLoad(List<PCGIdAndPayLoad> ppl, Long pcgId) {
        for (PCGIdAndPayLoad p : ppl) {
            if (p.getPagId().longValue() == pcgId.longValue()) {
                return p.getPayLoad();
            }
        }
        return 0;
    }

    /**
     * 查询商品信息
     * 
     * @param appId
     * @param pcgIds
     * @param consumerId
     * @param consumerCredits
     * @return
     */
    public Page<PCGCategorySellerGoodsDto> findGoods(Long appId, List<Long> pcgIds, Long consumerId,
                                                     Long consumerCredits, List<PCGIdAndPayLoad> pCGIdAndPayLoads,
                                                     Integer pageIndex, Integer pageSize) {
        List<PCGCategorySellerGoodsDto> goodsList = new ArrayList<PCGCategorySellerGoodsDto>();
        /*** 查询开启预分配商品列表 */
        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM,
                                                                                                              pcgIds);
        /*** 查询数据库商品列表 */
        Map<Long, PlatformCouponGoodsEntity> pcgs = platformCouponGoodsService.findByIds(pcgIds);
        for (Long pcgIdKey : pcgs.keySet()) {
            GoodsDirectionalConfigEntity gdce1 = null;
            GoodsDirectionalConfigEntity gdce2 = null;
            PlatformCouponGoodsEntity pce = pcgs.get(pcgIdKey);
            // 券是未启用状态,删除状态。返回
            if (PlatformCouponGoodsConstant.PcgStatusOn != pce.getPcgStatus().intValue() || pce.getDeleted()) {
                continue;
            }
            // 开启预分配
            if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, pce.getSwitches().intValue())) {
                if (!directionals.isEmpty()) {
                    // 查询是否存在清单
                    gdce1 = directionals.get(appId + "-" + pcgIdKey);
                    // 查询是否存在共享库，共享库appId是0
                    gdce2 = directionals.get(0 + "-" + pcgIdKey);
                    // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                    if (gdce1 == null && gdce2 == null) {
                        continue;
                    }

                }
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            ObjectUtil.convert(pce, psgd);
            GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
            // 设置库存
            if (gdce2 != null) {
                ObjectUtil.convert(gdce2, gc);
                if (gdce2.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                    DubboResult<Long> result = remoteStockBackendService.find(gdce2.getStockId());
                    if (result != null && result.isSuccess()) {
                        if (result.getResult() != null ) {
                            gc.setStock(result.getResult());
                        }
                    }
                }
            }
            if (gdce1 != null) {
                gc = new GoodsDirectionalConfigDto();
                ObjectUtil.convert(gdce1, gc);
                if (gdce1.getStockId() == null) {
                    gc.setStock(0L);
                } else {
                    // 当前商品预分配的库存
                    DubboResult<Long> result = remoteStockBackendService.find(gdce1.getStockId());
                    if (result != null && result.isSuccess()) {
                        if (result.getResult() != null ) {
                            gc.setStock(result.getResult());
                        }
                    }
                }
            }
            // 设置开奖预分配对象，积分展示需要调用
            psgd.setGoodsDirectionalConfigDto(gc);
            // 设置排序值
            psgd.setPayLoad(setPayLoad(pCGIdAndPayLoads, psgd.getPcgId()));
            long pcgStock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
            psgd.setStock(pcgStock);
            goodsList.add(psgd);
        }
        return page(pageIndex, pageSize, goodsList);
    }

    @Override
    public Page<PCGCategorySellerGoodsDto> findSellerGoods(long appId, long sellerId, Long consumerId,
                                                           Long consumerCredits, Integer pageIndex, Integer pageSize) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGIdAndPayLoad>();
        // 1.查询该类目下的所有商品
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntity = pCGSellerGoodsService.findAllGoodsBySeller(sellerId);
        for (PCGSellerGoodsEntity cateGoods : pCGSellerGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }

        // 2.商品进行单品黑名单过滤
        pcgIds = checkBlack(pcgIds, appId);
        Page<PCGCategorySellerGoodsDto> page = new Page<PCGCategorySellerGoodsDto>(pageSize, pageIndex);
        // 3.放入商品信息
        if (!pcgIds.isEmpty()) {
            page = findGoods(appId, pcgIds, consumerId, consumerCredits, pCGIdAndPayLoads, pageIndex, pageSize);
        }
        return page;
    }
    
    /**
     * 批量验证商品黑名单
     * @param pcgIds
     * @param appId
     * @return
     */
    @Override
    public List<Long>  checkBlack(List<Long> pcgIds,Long appId){
    	List<PCGCategoryEntity> cates=pCGFilterConfigService.findCategoryFilterList(appId);
    	Set<Long> catSet=new HashSet<>();
    	for(PCGCategoryEntity c:cates){
    		catSet.add(c.getId());
    	}
    	
    	List<PCGSellerEntity> sellers=pCGFilterConfigService.findSellerFilterList(appId);
    	Set<Long> sellerSet=new HashSet<>();
    	for(PCGSellerEntity e:sellers){
    		sellerSet.add(e.getId());
    	}
    	
    	Map<Long,List<PCGFilterConfigDto>> belongs= pCGFilterConfigService.findFilterCounponBelongs(catSet,sellerSet);
    	
    	List<PlatformCouponGoodsEntity> goodss=pCGFilterConfigService.findGoodsFilterList(appId);
    	boolean flag = true;
        Iterator<Long> ps = pcgIds.iterator();
        while (ps.hasNext()) {
        	flag = true;//标识商品是否已经加入黑名单
            long pcgId = ps.next();
            for (PlatformCouponGoodsEntity goods : goodss) {
                // 当前商品被屏蔽，清除
                if ((pcgId - goods.getPcgId()) == 0) {
                    ps.remove();
                    flag = false;
                    break;
                }
            }
            if(belongs !=null &&  !belongs.isEmpty()){
            	List<PCGFilterConfigDto> pcs =  belongs.get(pcgId);
            	if(flag && pcs !=null && !pcs.isEmpty()){
            		for(PCGFilterConfigDto f:belongs.get(pcgId)){
            			if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigCategoryType){
            				if(catSet.contains(f.getTargetId())){
            					//商品所属类目在黑名单中
            					ps.remove();
            					break;
            				}
            			}else if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigSellerType){
            				if(sellerSet.contains(f.getTargetId())){
            					//商品在所属品牌的黑名单中
            					ps.remove();
            					break;
            				}
            			}
            		}
            	}
            }
        }
        return pcgIds;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    public <T extends Comparable<? super T>> Page<T> page(Integer pageIndex, Integer pageSize, List<T> t) {
        Page<T> page = new Page<T>(pageSize, pageIndex);
        List<T> newList = new ArrayList<T>();
        page.setList(newList);
        if (t.isEmpty()) {
            return page;
        }
        Collections.sort(t);
        int total = t.size();
        int index = 0;// 循环索引开始
        // 大于两页
        if (pageIndex > 1) {
            index = (pageIndex - 1) * pageSize;
        }
        int totalPages = total % pageSize == 0 ? total / pageSize : (total / pageSize + 1);
        // 索引页必须小于总的页数
        if (pageIndex <= totalPages) {
            if (pageIndex == 1) {
                pageIndex = 0;
            }
            for (int i = index; i < total; i++) {
                // 只取20条，满足跳出
                if (pageSize * (pageIndex + 1) == i) {
                    break;
                }
                newList.add(t.get(i));
            }
        }
        page.setList(newList);
        page.setTotalPages(totalPages);
        page.setPageSize(pageSize);
        page.setCurrent(pageIndex);
        return page;
    }

}
