/**
 * Project Name:goods-center-biz
 * File Name:GoodsCenterConfigDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年6月3日上午9:44:14
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsCenterConfigDao;
import cn.com.duiba.goods.center.biz.entity.GoodsCenterConfigEntity;

/**
 * ClassName:GoodsCenterConfigDaoImpl <br/>
 * Date:     2016年6月3日 上午9:44:14 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("goodsCenterConfigDao")
public class GoodsCenterConfigDaoImpl extends BaseDao implements GoodsCenterConfigDao{

    @Override
    public int insert(String type, String content) {
        Map<String, Object> params=getBlankParams();
        params.put("type", type);
        params.put("content", content);
        return getSqlSession().insert(getStamentNameSpace("insert"), params);
    }

    @Override
    public GoodsCenterConfigEntity selectByType(String type) {
        Map<String, Object> params=getBlankParams();
        params.put("type", type);
        return getSqlSession().selectOne(getStamentNameSpace("selectByType"),params);
    }

    @Override
    public int update(String type, String content) {
        Map<String, Object> params=getBlankParams();
        params.put("type", type);
        params.put("content", content);
        return getSqlSession().update(getStamentNameSpace("update"),params);
        
    }

}

