package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponRetrieveLogDao;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponRetrieveLogEntity;
import org.springframework.stereotype.Repository;

import java.util.Map;

/**
 * Created by zjd .
 * 16/8/15 .
 */
@Repository("goodsCouponRetrieveLogDao")
public class GoodsCouponRetrieveLogDaoImpl extends BaseDao implements GoodsCouponRetrieveLogDao {
    @Override
    public Long insert(GoodsCouponRetrieveLogEntity entity) {
        getSqlSession().insert(getStamentNameSpace("insert"), entity);
        return entity.getId();
    }

    @Override
    public boolean updateStatusSuccess(Long id ,String filePath,int count) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("filePath", filePath);
        params.put("count", count);
        int updateStatusSuccess = getSqlSession().update(getStamentNameSpace("updateStatusSuccess"), params);
        return updateStatusSuccess!=1?false:true;
    }

    @Override
    public boolean updateStatusPart(Long id ,String filePath,int count) {
        Map<String, Object> params=getBlankParams();

        params.put("id", id);
        params.put("filePath", filePath);
        params.put("count", count);
        int updateStatusPart = getSqlSession().update(getStamentNameSpace("updateStatusPart"), params);
        return updateStatusPart!=1?false:true;
    }

    @Override
    public GoodsCouponRetrieveLogEntity findById(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("select"),id);

    }

    @Override
    public boolean updateStatusFail(Long id) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        int updateStatusPart = getSqlSession().update(getStamentNameSpace("updateStatusFail"), params);
        return updateStatusPart!=1;
    }
}
