package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.PhoneBillListsDao;
import cn.com.duiba.goods.center.biz.entity.PhonebillListEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/8/8.
 */
@Repository("phoneBillListsDao")
public class PhoneBillListsDaoImpl extends BaseCreditsDao implements PhoneBillListsDao {

    @Override
    public List<PhonebillListEntity> findByMobileAndFacePrice(String mobile,
                                                          Integer facePrice) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("mobile", mobile);
        map.put("facePrice", facePrice);
        return sqlSession.selectList(getStamentNameSpace("findByMobileAndFacePrice"), map);
    }

    @Override
    public List<PhonebillListEntity> findAllInFacePrice(List<Integer> facePrices) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("facePrices", facePrices);
        return sqlSession.selectList(getStamentNameSpace("findAllInFacePrice"), map);
    }

    @Override
    public PhonebillListEntity findByFacePriceAndMobile(Integer price, String mobile) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("price", price);
        map.put("mobile", mobile);
        return sqlSession.selectOne(getStamentNameSpace("findByFacePriceAndMobile"), map);
    }

    @Override
    public List<PhonebillListEntity> findAll() {
        return sqlSession.selectList(getStamentNameSpace("findAll"));
    }

    @Override
    public void delete(Long id) {
        sqlSession.delete(getStamentNameSpace("delete"), id);
    }

    @Override
    public void insert(PhonebillListEntity phonebillListEntity) {
        sqlSession.insert(getStamentNameSpace("insert"), phonebillListEntity);
    }

    @Override
    public void update(PhonebillListEntity phonebillListEntity) {
        sqlSession.update(getStamentNameSpace("update"), phonebillListEntity);
    }

    @Override
    public PhonebillListEntity find(Long id) {
        return sqlSession.selectOne(getStamentNameSpace("find"), id);
    }
}
