package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.RemotePhoneBillListsService;
import cn.com.duiba.goods.center.api.remoteservice.dto.PhonebillListDto;
import cn.com.duiba.goods.center.biz.service.PhoneBillListsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by yansen on 16/8/8.
 */
@Service
public class RemotePhoneBillListsServiceImpl implements RemotePhoneBillListsService {

    @Resource
    private PhoneBillListsService phoneBillListsService;

    @Override
    public DubboResult<List<PhonebillListDto>> findByMobileAndFacePrice(String mobile, Integer facePrice) {
        return DubboResult.successResult(phoneBillListsService.findByMobileAndFacePrice(mobile,facePrice));
    }

    @Override
    public DubboResult<List<PhonebillListDto>> findAllInFacePrice(List<Integer> facePrices) {
        return DubboResult.successResult(phoneBillListsService.findAllInFacePrice(facePrices));
    }

    @Override
    public DubboResult<PhonebillListDto> findByFacePriceAndMobile(Integer price, String mobile) {
        return DubboResult.successResult(phoneBillListsService.findByFacePriceAndMobile(price, mobile));
    }

    @Override
    public DubboResult<List<PhonebillListDto>> findAll() {
        return DubboResult.successResult(phoneBillListsService.findAll());
    }

    @Override
    public DubboResult<Void> delete(Long id) {
        phoneBillListsService.delete(id);
        return DubboResult.successResult(null);
    }

    @Override
    public DubboResult<PhonebillListDto> insert(PhonebillListDto phonebillListDto) {
        phoneBillListsService.insert(phonebillListDto);
        return DubboResult.successResult(phonebillListDto);
    }

    @Override
    public DubboResult<Void> update(PhonebillListDto phonebillListDto) {
        phoneBillListsService.update(phonebillListDto);
        return DubboResult.successResult(null);
    }

    @Override
    public DubboResult<PhonebillListDto> find(Long id) {
        return DubboResult.successResult(phoneBillListsService.find(id));
    }
}
