package cn.com.duiba.goods.center.biz.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.constant.PlatformCouponGoodsConstant;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.PCGFilterConfigBO;
import cn.com.duiba.goods.center.biz.bo.impl.PCGFilterConfigBOImpl;
import cn.com.duiba.goods.center.biz.bo.impl.PCGFilterConfigBOImpl.PCGIdAndPayLoad;
import cn.com.duiba.goods.center.biz.bo.pcg.PCGUtilBO;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.dao.PCGFilterConfigDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PlatformCouponGoodsDao;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.remoteservice.impl.RemotePCGFilterConfigBackendServiceImpl;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

import com.alibaba.fastjson.JSONObject;
/**
 * ClassName:PCGFilterConfigServiceImpl <br/>
 * Date:     2016年6月13日 下午12:23:22 <br/>
 * @author   zhengjy
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class PCGFilterConfigServiceImpl implements PCGFilterConfigService{

    @Autowired
    private PCGFilterConfigDao            pCGFilterConfigDao;
    @Autowired
    private PlatformCouponGoodsDao        platformCouponGoodsDao;
    @Autowired
    private PCGCategoryDao                pCGCategoryDao;
    @Autowired
    private PCGSellerDao                  pCGSellerDao;
    @Autowired
    private PCGSellerGoodsService         pCGSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService       pCGCategoryGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RemoteStockBackendService     remoteStockBackendService;
    @Autowired
    private GoodsLimitRecordService       goodsLimitRecordService;
    @Autowired
    private GoodsBatchCouponBackendBO     goodsBatchCouponBackendBO;
    @Autowired
    private RemoteAppService              remoteAppService;
    @Autowired
    private GoodsBatchService             goodsBatchService;
    @Autowired
    private GoodsContentService           goodsContentService;
    @Autowired
    private PCGUtilBO                     pCGUtilBO;
    @Autowired
    private PCGFilterConfigBO             pCGFilterConfigBO;

    @Override
    public List<PlatformCouponGoodsEntity> findGoodsFilterList(Long appId) {
        List<Long> pcgIds = pCGFilterConfigDao.selectPCGFilterTargetIds(appId,
                                                                        PlatformCouponGoodsConstant.PcgFilterConfigGoodsType);
        if (pcgIds.isEmpty()) {
            return new ArrayList<PlatformCouponGoodsEntity>();
        }
        return platformCouponGoodsDao.selectByIds(pcgIds);
    }

    @Override
    public List<PCGCategoryEntity> findCategoryFilterList(Long appId) {
        List<Long> categoryIds = pCGFilterConfigDao.selectPCGFilterTargetIds(appId,
                                                                             PlatformCouponGoodsConstant.PcgFilterConfigCategoryType);
        if (categoryIds.isEmpty()) {
            return new ArrayList<PCGCategoryEntity>();
        }
        return pCGCategoryDao.selectByIds(categoryIds);
    }

    @Override
    public List<PCGSellerEntity> findSellerFilterList(Long appId) {
        List<Long> sellerIds = pCGFilterConfigDao.selectPCGFilterTargetIds(appId,
                                                                           PlatformCouponGoodsConstant.PcgFilterConfigSellerType);
        if (sellerIds.isEmpty()) {
            return new ArrayList<PCGSellerEntity>();
        }
        return pCGSellerDao.selectByIds(sellerIds);
    }

    @Override
    public List<PCGFilterConfigDto> findCounponBelong(Long goodsId) {
        List<PCGFilterConfigDto> list = new ArrayList<PCGFilterConfigDto>();
        PCGFilterConfigDto pcd = new PCGFilterConfigDto();
        /** 查询商品归属商家 */
        Long sellerGoods = pCGFilterConfigDao.selectGoodsSeller(goodsId);
        if (sellerGoods != null) {
            /** 查询商品名称 */
            PCGSellerEntity pCGSellerEntity = pCGSellerDao.select(sellerGoods);
            if (pCGSellerEntity != null) {
                pcd.setType(PlatformCouponGoodsConstant.PcgFilterConfigSellerType);
                pcd.setTargetId(pCGSellerEntity.getId());
                pcd.setTargetName(pCGSellerEntity.getName());
                list.add(pcd);
            }
        }
        /** 查询分类归属类别列表 */
        List<Long> categoryIds = pCGFilterConfigDao.selectGoodsCategory(goodsId);
        if (categoryIds != null && !categoryIds.isEmpty()) {
            /** 查询类别名称 */
            List<PCGCategoryEntity> categorys = pCGCategoryDao.selectByIds(categoryIds);
            for (PCGCategoryEntity category : categorys) {
                pcd = new PCGFilterConfigDto();
                pcd.setType(PlatformCouponGoodsConstant.PcgFilterConfigCategoryType);
                pcd.setTargetId(category.getId());
                pcd.setTargetName(category.getName());
                list.add(pcd);
            }
        }
        return list;
    }

    @Override
    public Long insert(long appId, int type, long targetId) {
        return pCGFilterConfigDao.insert(appId, type, targetId);
    }

    @Override
    public int delete(long appId, int type, long targetId) {
        return pCGFilterConfigDao.delete(appId, type, targetId);
    }

    @Override
    public PCGFilterConfigEntity select(Long id) {
        return pCGFilterConfigDao.select(id);
    }

    @Override
    public List<Long> selectPCGFilterTargetIds(Long appId, Integer type) {
        return pCGFilterConfigDao.selectPCGFilterTargetIds(appId, type);
    }

    @Override
    public List<PCGCategorySellerGoodsDto> selectPCGCategoryGoodsList(Long appId) {
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGFilterConfigBOImpl.PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGFilterConfigBOImpl.PCGIdAndPayLoad>();
        List<PCGCategorySellerGoodsDto> platformCouponGoodss = new ArrayList<PCGCategorySellerGoodsDto>();
        /*** 分类列表查询 */
        List<PCGCategoryEntity> pCGCategoryEntitys = pCGCategoryDao.selectAll();
        List<Long> catIds = new ArrayList<Long>();
        for (PCGCategoryEntity c : pCGCategoryEntitys) {
            catIds.add(c.getId());
        }
        /*** 查询该分类下的所有商品 */
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = pCGCategoryGoodsService.findAllGoodsByCateIds(catIds);
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        /*** 查询开启预分配商品列表 */
        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM,
                                                                                                              pcgIds);
        List<PlatformCouponGoodsEntity> ps = platformCouponGoodsDao.selectByIds(pcgIds);
        for (PlatformCouponGoodsEntity pce : ps) {
            if (!pCGUtilBO.isInBlack(pce, appId)) {
                // 券是启用状态,未删除状态
                if (PlatformCouponGoodsConstant.PcgStatusOn == pce.getPcgStatus() && !pce.getDeleted()) {
                    // 是否开启预分配
                    if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, pce.getSwitches().intValue())) {
                        // 查询是否存在清单
                        GoodsDirectionalConfigEntity gdce1 = directionals.get(appId + "-" + pce.getPcgId());
                        GoodsDirectionalConfigEntity gdce2 = directionals.get(0 + "-" + pce.getPcgId());
                        // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                        if (gdce1 == null && gdce2 == null) {
                            continue;
                        }
                    }
                    PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
                    psgd.setIconImage(pce.getIconImage());
                    psgd.setPcgId(pce.getPcgId());
                    psgd.setTitle(pce.getTitle());
                    psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, pce.getPcgId()));
                    if (!platformCouponGoodss.contains(psgd)) {
                        platformCouponGoodss.add(psgd);
                    }
                }
            }
        }
        return platformCouponGoodss;
    }

    @Override
    public List<PCGCategorySellerGoodsDto> selectPCGSellerGoodsList(Long appId) {
        /*** 品牌列表查询 */
        List<PCGSellerEntity> pCGSellerEntitys = pCGSellerDao.selectAll();
        List<Long> sellerIds = new ArrayList<Long>();
        List<Long> pcgIds = new ArrayList<Long>();
        List<PCGCategorySellerGoodsDto> platformCouponGoodss = new ArrayList<PCGCategorySellerGoodsDto>();
        List<PCGFilterConfigBOImpl.PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGFilterConfigBOImpl.PCGIdAndPayLoad>();
        for (PCGSellerEntity c : pCGSellerEntitys) {
            sellerIds.add(c.getId());
        }
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntitys = pCGSellerGoodsService.findAllGoodsBySellerIds(sellerIds);
        for (PCGSellerGoodsEntity sellerGoods : pCGSellerGoodsEntitys) {
            pcgIds.add(sellerGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGIdAndPayLoad(sellerGoods.getPcgId(), sellerGoods.getPayload()));
        }
        /*** 查询开启预分配商品列表 */
        Map<String, GoodsDirectionalConfigEntity> directionals = goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM,
                                                                                                              pcgIds);
        List<PlatformCouponGoodsEntity> ps = platformCouponGoodsDao.selectByIds(pcgIds);
        /*** 查询分类下商品 */
        for (PlatformCouponGoodsEntity pce : ps) {
            if (!pCGUtilBO.isInBlack(pce, appId)) {
                // 券是启用状态,未删除状态
                if (PlatformCouponGoodsConstant.PcgStatusOn == pce.getPcgStatus() && !pce.getDeleted()) {
                    if (isOpen(PlatformCouponGoodsConstant.PcgDirectionalSwitches, pce.getSwitches().intValue())) {
                        // 查询是否存在清单
                        GoodsDirectionalConfigEntity gdce1 = directionals.get(appId + "-" + pce.getPcgId());
                        GoodsDirectionalConfigEntity gdce2 = directionals.get(0 + "-" + pce.getPcgId());
                        // 如果券开启了库存预分配，且当前应用和共享库均不在预分配清单中则不展示；
                        if (gdce1 == null && gdce2 == null) {
                            continue;
                        }
                    }
                }
                PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
                psgd.setIconImage(pce.getIconImage());
                psgd.setPcgId(pce.getPcgId());
                psgd.setTitle(pce.getTitle());
                psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, pce.getPcgId()));
                platformCouponGoodss.add(psgd);
            }
        }
        return platformCouponGoodss;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    @Override
    public PCGCategorySellerGoodsDto findSellerGoodsInfo(long appId, long gid, Long consumerId, Long consumerCredits)
                                                                                                                     throws Exception {

        /* 查询缓存中券的信息 */
        PlatformCouponGoodsEntity pce = platformCouponGoodsDao.selectByPcgId(gid);
        // 查询平台券信息
        GoodsContentEntity goods = goodsContentService.findByGoods(GoodsTypeEnum.PLATFORM, gid);
        if (pce == null || goods == null) {
            throw new Exception("找不到 对应的 平台券信息");
        }

        /* 读取缓存当前app下被屏蔽的商品列表 */
        RedisFilterCache redisFilterCache = new RedisFilterCache(redisTemplate);
        List<Long> filterGoodsIds = redisFilterCache.getFilterListCache(redisFilterCache.getFilterConfigRedisKey(appId,
                                                                                                                 PlatformCouponGoodsConstant.PcgFilterConfigGoodsType),
                                                                        Long.class);
        if (filterGoodsIds == null || filterGoodsIds.isEmpty()) {
            /*** 查询数据库当前app下被屏蔽的商品列表 */
            filterGoodsIds = pCGFilterConfigDao.selectPCGFilterTargetIds(appId,
                                                                         PlatformCouponGoodsConstant.PcgFilterConfigGoodsType);
        }

        // 查询 该券 有没有被 开发者屏蔽
        if (!filterGoodsIds.isEmpty()) {
            for (Long filterGoodsId : filterGoodsIds) {
                // 当前商品被屏蔽，清除
                if ((pce.getPcgId() - filterGoodsId) == 0) {
                    throw new Exception("该券 已被开发者屏蔽");
                }
            }
        }

        // 券是启用状态,未删除状态
        PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
        if (PlatformCouponGoodsConstant.PcgStatusOn == pce.getPcgStatus() && !pce.getDeleted()) {
            ObjectUtil.convert(pce, psgd);
        } else {
            throw new Exception("该券已下架");
        }

        // 设置 图片
        psgd.setIconImage(pce.getDetailImage());
        // 描述详情信息
        psgd.setDetail(goods.getContent());

        GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
        gc.setStock(0L);

        // 设置开奖预分配对象，积分展示需要调用
        psgd.setGoodsDirectionalConfigDto(gc);
        // 设置库存
        long pcgStock = goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
        psgd.setStock(pcgStock);
        return psgd;
    }

	@Override
	public Map<Long, List<PCGFilterConfigDto>> findFilterCounponBelongs(Set<Long> catSet,Set<Long> sellerSet) {
        PCGFilterConfigDto pcd = new PCGFilterConfigDto();
        Map<Long, List<PCGFilterConfigDto>> map= new HashMap<Long, List<PCGFilterConfigDto>>();
        
        /** 查询商品归属商家 */
        List<Long> sellerIds =  new ArrayList<Long>(sellerSet);
        if(sellerIds !=null && !sellerIds.isEmpty()){
        	List<PCGSellerGoodsEntity> sellerGoods= pCGSellerGoodsService.findAllGoodsBySellerIds(sellerIds);
    		for(PCGSellerGoodsEntity sellerGood:sellerGoods){
    			pcd = new PCGFilterConfigDto();
    			pcd.setType(PlatformCouponGoodsConstant.PcgFilterConfigSellerType);
    			pcd.setTargetId(sellerGood.getSellerId());
				List<PCGFilterConfigDto> l = map.get(sellerGood.getPcgId());
				if(l==null){
					l= new ArrayList<PCGFilterConfigDto>();
					map.put(sellerGood.getPcgId(),l);
				}
				l.add(pcd);
    		}
        }
        
        /** 查询分类归属类别列表 */
        List<Long> categoryIds =  new ArrayList<Long>(catSet);
    	if(categoryIds !=null && !categoryIds.isEmpty()){
    		List<PCGCategoryGoodsEntity> cateGoods= pCGCategoryGoodsService.findAllGoodsByCateIds(categoryIds);
    		for (PCGCategoryGoodsEntity cateGood:cateGoods) {
    			pcd = new PCGFilterConfigDto();
    			pcd.setType(PlatformCouponGoodsConstant.PcgFilterConfigCategoryType);
    			pcd.setTargetId(cateGood.getCategoryId());
				List<PCGFilterConfigDto> l =map.get(cateGood.getPcgId());
				if(l==null){
					l=new ArrayList<PCGFilterConfigDto>();
					map.put(cateGood.getPcgId(), l);
				}
				l.add(pcd);
    		}
    	}
        
       
       
		
		return map;
	}

}

class RedisFilterCache {

    public RedisFilterCache(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;

    }

    private static Logger                 log = LoggerFactory.getLogger(RemotePCGFilterConfigBackendServiceImpl.class);
    private RedisTemplate<String, String> redisTemplate;

    /**
     * 获取List缓存
     * 
     * @return
     * @return
     */
    @SuppressWarnings("unchecked")
    public <T> T getFilterListCache(String key, Class clazz) {
        String string = redisTemplate.opsForValue().get(key);
        if (string == null) {
            return null;
        }
        return (T) JSONObject.parseArray(string, clazz);
    }

    /**
     * 获取Object缓存
     * 
     * @return
     * @return
     */
    public Object getFilterObjectCache(String key, Class clazz) {
        String string = redisTemplate.opsForValue().get(key);
        if (string == null) {
            return null;
        }
        return (Object) JSONObject.parseObject(string);
    }

    /*** 删除缓存 */
    public void clearFilterCache(String key) {
        try {
            redisTemplate.delete(key);
        } catch (Exception e) {
            log.error("RedisBatchCache.clearBatchsCache key=" + key, e);
        }
    }

    /*** 设置缓存 */
    public <T> void setFilterCache(String key, T t) {
        String string = JSONObject.toJSONString(t);
        redisTemplate.opsForValue().set(key, string);
        redisTemplate.expire(key, 1, TimeUnit.HOURS);
    }

    public String getSellerGoodsRedisKey(String sellerId) {
        return RedisKeyTool.getSellerGoodsRedisKey(sellerId);
    }

    public String getCategoryGoodsRedisKey(String categoryId) {
        return RedisKeyTool.getCategoryGoodsRedisKey(categoryId);
    }

    public String getPlatformRedisKey(String pcgId) {
        return RedisKeyTool.getPlatformRedisKey(pcgId);
    }

    public String getDirectionalRedisKey(Long pcgId, Long appId) {
        return RedisKeyTool.getDirectionalRedisKey(pcgId + "-" + appId);
    }

    public String getFilterConfigRedisKey(Long appId, Integer type) {
        return RedisKeyTool.getDirectionalRedisKey(appId + "-" + type);
    }

    public String getCategoryRedisKey() {
        return RedisKeyTool.getCategoryRedisKey();
    }

    public String getSellerRedisKey() {
        return RedisKeyTool.getSellerRedisKey();
    }

}


