package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.PhonebillListDto;
import cn.com.duiba.goods.center.biz.dao.PhoneBillListsDao;
import cn.com.duiba.goods.center.biz.entity.PhonebillListEntity;
import cn.com.duiba.goods.center.biz.service.PhoneBillListsService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by yansen on 16/8/8.
 */
@Service
public class PhoneBillListsServiceImpl implements PhoneBillListsService {

    @Resource
    private PhoneBillListsDao phoneBillListsDao;

    @Override
    public List<PhonebillListDto> findByMobileAndFacePrice(String mobile, Integer facePrice) {
        return BeanUtils.copyList(phoneBillListsDao.findByMobileAndFacePrice(mobile, facePrice),PhonebillListDto.class);
    }

    @Override
    public List<PhonebillListDto> findAllInFacePrice(List<Integer> facePrices) {
        return BeanUtils.copyList(phoneBillListsDao.findAllInFacePrice(facePrices),PhonebillListDto.class);
    }

    @Override
    public PhonebillListDto findByFacePriceAndMobile(Integer price, String mobile) {
        return BeanUtils.copy(phoneBillListsDao.findByFacePriceAndMobile(price, mobile),PhonebillListDto.class);
    }

    @Override
    public List<PhonebillListDto> findAll() {
        return BeanUtils.copyList(phoneBillListsDao.findAll(),PhonebillListDto.class);
    }

    @Override
    public void delete(Long id) {
        phoneBillListsDao.delete(id);
    }

    @Override
    public void insert(PhonebillListDto phonebillListDto) {
        PhonebillListEntity entity=BeanUtils.copy(phonebillListDto,PhonebillListEntity.class);
        phoneBillListsDao.insert(entity);
        phonebillListDto.setId(entity.getId());
    }

    @Override
    public void update(PhonebillListDto phonebillListDto) {
        phoneBillListsDao.update(BeanUtils.copy(phonebillListDto,PhonebillListEntity.class));
    }

    @Override
    public PhonebillListDto find(Long id) {
        return BeanUtils.copy(phoneBillListsDao.find(id),PhonebillListDto.class);
    }
}
