/**
 * Project Name:goods-center-biz
 * File Name:StockService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年6月28日下午2:42:35
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.stock;

import java.util.List;

/**
 * ClassName:StockService <br/>
 * Function: 库存服务 <br/>
 * Date:     2016年6月28日 下午2:42:35 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface StockService {
    /**
     * 查询一个商品在下单时需要哪些额外的库存进行减一动作<br/>
     * (不包含主库存)<br/>
     * 
     * 平台券：定向App库存
     *
     * @author xuhengfei
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @return
     * @since JDK 1.6
     */
    List<Long> getNeedCountDownOtherStockIds(int gtype,long gid,long appId);
}

