/**
 * Project Name:goods-center-biz File Name:ConsumeStockTypeUtil.java Package Name:cn.com.duiba.goods.center.biz.util
 * Date:2016年7月15日上午9:08:54 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.goods.center.biz.util;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.stock.service.api.constant.ConsumeStockTypes;

/**
 * ClassName:ConsumeStockTypeUtil <br/>
 * Function: 库存中心消费类型辅助类 <br/>
 * Date: 2016年7月15日 上午9:08:54 <br/>
 * 
 * @author xuhengfei
 * @version
 * @since JDK 1.6
 * @see
 */
public class ConsumeStockTypeUtil {

    public static ConsumeStockTypes getConsumeStockTypes(GoodsTypeEnum gtype) {
        if (gtype == GoodsTypeEnum.PLATFORM) {
            return ConsumeStockTypes.PcgItemTakeOrder;
        }else if(gtype==GoodsTypeEnum.ADVERT){
            return ConsumeStockTypes.AcgTakeOrder;
        }else{
            throw new RuntimeException("暂不支持");
        }
    }
}
