/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.stock.StockService;
import cn.com.duiba.goods.center.biz.util.ConsumeStockTypeUtil;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerBackendService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponService")
public class GoodsCouponServiceImpl
implements GoodsCouponService {
    private static Logger log = LoggerFactory.getLogger(GoodsCouponServiceImpl.class);
    @Autowired
    private GoodsCouponDao goodsCouponDao;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private StockService stockService;
    @Resource
    protected RemoteConsumerService remoteConsumerService;
    @Autowired
    protected GoodsCouponService goodsCouponService;
    @Autowired
    private RemoteIDMakerBackendService remoteIDMakerBackendService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private RedisTemplate<String, String> normalCouponCountTemplate;
    private LinkRepeatCouponRecordRedis linkRepeatCouponRecordRedis = new LinkRepeatCouponRecordRedis();

    public static void main(String[] args) {
        GoodsCouponEntity e = new GoodsCouponEntity();
        e.setCode("code11");
        String o = JSONObject.toJSONString((Object)e);
        System.out.println(o);
        GoodsCouponEntity c = (GoodsCouponEntity)JSONObject.parseObject((String)o, GoodsCouponEntity.class);
        System.out.println(c.getCode());
    }

    @Override
    public GoodsCouponEntity find(Long goodsCouponId) {
        return this.goodsCouponDao.selectByCouponId(goodsCouponId);
    }

    @Override
    public Boolean updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link) {
        int ret = this.goodsCouponDao.updateLinkCoupon(gtype, gid, batchId, link);
        if (ret == 1) {
            this.linkRepeatCouponRecordRedis.clear(batchId);
            return true;
        }
        return false;
    }

    @Override
    public void importLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String link) {
        this.goodsCouponDao.insertLinkCoupon(gtype, gid, goodsBatchId, goodsCouponId, link);
    }

    @Override
    public void importRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String code, String password) {
        this.goodsCouponDao.insertRepeatCoupon(gtype, gid, goodsBatchId, goodsCouponId, code, password);
    }

    @Override
    public Boolean updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password) {
        int ret = this.goodsCouponDao.updateRepeatCoupon(gtype, gid, batchId, code, password);
        if (ret == 1) {
            this.linkRepeatCouponRecordRedis.clear(batchId);
            return true;
        }
        return false;
    }

    @Override
    public Integer importNormalCoupons(GoodsBatchEntity batch, List<GoodsCouponDao.CouponFormat> coupons) {
        if (coupons.size() > 1000000) {
            throw new RuntimeException("\u8d85\u51fa100W\uff0c\u62d2\u7edd\u5bfc\u5165");
        }
        int MAX_RECORDS = 20000;
        int size = coupons.size();
        int batchs = size % 20000 == 0 ? size / 20000 : size / 20000 + 1;
        ArrayList group = new ArrayList(batchs);
        HashMap<Integer, AtomicInteger> countMap = new HashMap<Integer, AtomicInteger>();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < batchs; ++i) {
            ArrayList l = new ArrayList(20000);
            group.add(l);
            countMap.put(i, new AtomicInteger());
        }
        block1: for (GoodsCouponDao.CouponFormat cf : coupons) {
            if (set.add(cf.getCode())) {
                for (int i = 0; i < group.size(); ++i) {
                    List cflist = (List)group.get(i);
                    if (((AtomicInteger)countMap.get(i)).get() >= 20000) continue;
                    ((AtomicInteger)countMap.get(i)).incrementAndGet();
                    cflist.add(cf);
                    continue block1;
                }
                continue;
            }
            log.debug("\u91cd\u590d\u5238\u7801 code=" + cf.getCode());
        }
        int totalSuccess = 0;
        for (List list : group) {
            if (list.isEmpty()) continue;
            totalSuccess += this.goodsCouponDao.insertBatchImport(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid(), batch.getId(), list);
        }
        DubboResult stockRet = this.remoteStockBackendService.increaseItemStock(batch.getStockId().longValue(), (long)totalSuccess);
        if (!stockRet.isSuccess()) {
            log.error("remoteStockBackendService.increaseItemStock fail ,msg=" + stockRet.getMsg());
        } else if (!((Boolean)stockRet.getResult()).booleanValue()) {
            log.error("remoteStockBackendService.increaseItemStock error ,msg=" + stockRet.getMsg());
        }
        return totalSuccess;
    }

    @Override
    public Page<GoodsCouponEntity> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex, int total) {
        Page page = new Page(pageSize, pageIndex);
        int count = total;
        int start = (pageIndex - 1) * pageSize;
        int limit = pageSize;
        List<GoodsCouponEntity> list = this.goodsCouponDao.selectPageByBatchId(gtype, gid, batchId, start, limit);
        page.setTotalPages(count % pageSize == 0 ? count / pageSize : count / pageSize + 1);
        page.setList(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public List<GoodsCouponEntity> findPageByStatus(GoodsTypeEnum gtype, long gid, long batchId, int status, int start, int limit) {
        List<GoodsCouponEntity> list = this.goodsCouponDao.selectPageByBatchIdAndStatus(gtype, gid, batchId, status, start, limit);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean consumeStocks(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, String bizNum, ConsumerDO c) {
        DubboResult batchStock = this.remoteStockService.find(batch.getStockId().longValue());
        if (batchStock.isSuccess() && (Long)batchStock.getResult() <= 0L) {
            throw new RuntimeGoodsException(ErrorCode.E0202005);
        }
        List<Long> stockIds = null;
        try {
            DBTimeProfile.enter((String)"getNeedCountDownOtherStockIds");
            stockIds = this.stockService.getNeedCountDownOtherStockIds(gtype.getGtype(), batch.getGid(), c.getAppId());
        }
        finally {
            DBTimeProfile.release();
        }
        stockIds.add(batch.getStockId());
        try {
            DBTimeProfile.enter((String)"remoteStockService.decreaseGoodStock");
            DubboResult stockRet = this.remoteStockService.consumeStock(ConsumeStockTypeUtil.getConsumeStockTypes(gtype).getType(), bizNum, stockIds);
            if (!stockRet.isSuccess() || !((Boolean)stockRet.getResult()).booleanValue()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            DBTimeProfile.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsCouponEntity takeNormalCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, String bizNum) {
        ConsumerDO c = this.remoteConsumerService.find(Long.valueOf(consumerId));
        try {
            DBTimeProfile.enter((String)"GoodsCouponServiceImpl.takeNormalCoupon");
            if (!this.consumeStocks(gtype, batch, consumerId, bizNum, c)) {
                GoodsCouponEntity goodsCouponEntity = null;
                return goodsCouponEntity;
            }
            GoodsCouponEntity entity = this.goodsCouponDao.selectOneCouponNotUsed(gtype, batch.getGid(), batch.getId());
            boolean success = this.takeCoupon4Point(gtype, batch.getGid(), batch.getId(), entity.getGoodsCouponId(), consumerId);
            if (success) {
                GoodsCouponEntity goodsCouponEntity = entity;
                return goodsCouponEntity;
            }
            GoodsCouponEntity goodsCouponEntity = null;
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsCouponEntity takeLinkCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, String bizNum) {
        ConsumerDO c = this.remoteConsumerService.find(Long.valueOf(consumerId));
        boolean consumeSucc = this.consumeStocks(gtype, batch, consumerId, bizNum, c);
        if (!consumeSucc) {
            return null;
        }
        try {
            DBTimeProfile.enter((String)"selectOneByGoodsBatchId");
            GoodsCouponEntity e = this.linkRepeatCouponRecordRedis.get(batch.getId());
            if (e != null) {
                GoodsCouponEntity goodsCouponEntity = e;
                return goodsCouponEntity;
            }
            e = this.goodsCouponDao.selectOneByGoodsBatchId(gtype, batch.getGid(), batch.getId());
            if (e != null) {
                this.linkRepeatCouponRecordRedis.set(batch.getId(), e);
            }
            GoodsCouponEntity goodsCouponEntity = e;
            return goodsCouponEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public GoodsCouponEntity takeRepeatCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, String bizNum) {
        ConsumerDO c = this.remoteConsumerService.find(Long.valueOf(consumerId));
        boolean consumeSucc = this.consumeStocks(gtype, batch, consumerId, bizNum, c);
        if (!consumeSucc) {
            return null;
        }
        GoodsCouponEntity e = this.linkRepeatCouponRecordRedis.get(batch.getId());
        if (e != null) {
            return e;
        }
        e = this.goodsCouponDao.selectOneByGoodsBatchId(gtype, batch.getGid(), batch.getId());
        if (e != null) {
            this.linkRepeatCouponRecordRedis.set(batch.getId(), e);
        }
        return e;
    }

    @Override
    public void completeCoupon(Long couponId, long orderId) {
        this.goodsCouponDao.updateCoupnoMarkUsed(couponId, orderId);
    }

    @Override
    public Boolean rollbackNormalCoupon(Long couponId) {
        int ret = this.goodsCouponDao.updateCouponMarkRollback(couponId);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    protected List<GoodsCouponEntity> loadCouponByBatchId(GoodsTypeEnum gtype, long gid, long batchId, int limit) {
        return this.goodsCouponDao.selectBatchNotUsed(gtype, gid, batchId, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean takeCoupon4Point(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, long consumerId) {
        try {
            DBTimeProfile.enter((String)"GoodsCouponServiceImpl.takeCoupon4Point");
            int ret = this.goodsCouponDao.updateCouponMarkLocked(gtype, gid, goodsBatchId, goodsCouponId, consumerId);
            if (ret == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public GoodsCouponEntity findOneByGoodsBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        return this.goodsCouponDao.selectOneByGoodsBatchId(gtype, gid, goodsBatchId);
    }

    @Override
    public List<GoodsCouponEntity> searchByCode(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code) {
        return this.goodsCouponDao.selectSearchByCode(gtype, gid, goodsBatchId, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteGoodsCoupon(GoodsTypeEnum gtype, long gid, long batchId) {
        try {
            DBTimeProfile.enter((String)"GoodsCouponServiceImpl.deleteGoodsCoupon");
            int ret = this.goodsCouponDao.deleteGoodsCoupon(gtype, gid, batchId);
            if (ret == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteGoodsCouponByIds(long gid, List<Long> ids) {
        int ret = 0;
        try {
            DBTimeProfile.enter((String)"GoodsCouponServiceImpl.deleteGoodsCouponByIds");
            ret = this.goodsCouponDao.deleteGoodsCouponByIds(gid, ids);
        }
        finally {
            DBTimeProfile.release();
        }
        return ret;
    }

    private class LinkRepeatCouponRecordRedis {
        private LinkRepeatCouponRecordRedis() {
        }

        public void set(Long batchId, GoodsCouponEntity entity) {
            try {
                String key = RedisKeyTool.getRedisKey(GoodsCouponServiceImpl.class, (String)"linkrepeat-record", (String)(batchId + ""));
                String string = JSONObject.toJSONString((Object)entity);
                GoodsCouponServiceImpl.this.normalCouponCountTemplate.opsForValue().set((Object)key, (Object)string);
            }
            catch (Exception e) {
                log.error("LinkRepeatCouponRecordRedis.set error", (Throwable)e);
            }
        }

        public void clear(long batchId) {
            try {
                String key = RedisKeyTool.getRedisKey(GoodsCouponServiceImpl.class, (String)"linkrepeat-record", (String)(batchId + ""));
                GoodsCouponServiceImpl.this.normalCouponCountTemplate.delete((Object)key);
            }
            catch (Exception e) {
                log.error("LinkRepeatCouponRecordRedis.clear error", (Throwable)e);
            }
        }

        public GoodsCouponEntity get(long batchId) {
            try {
                String key = RedisKeyTool.getRedisKey(GoodsCouponServiceImpl.class, (String)"linkrepeat-record", (String)(batchId + ""));
                String string = (String)GoodsCouponServiceImpl.this.normalCouponCountTemplate.opsForValue().get((Object)key);
                if (string != null) {
                    return (GoodsCouponEntity)JSONObject.parseObject((String)string, GoodsCouponEntity.class);
                }
            }
            catch (Exception e) {
                log.error("LinkRepeatCouponRecordRedis.get error", (Throwable)e);
            }
            return null;
        }
    }
}

