/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsDirectionalConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.bo.impl.PCGFilterConfigBOImpl;
import cn.com.duiba.goods.center.biz.bo.pcg.PCGUtilBO;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryDao;
import cn.com.duiba.goods.center.biz.dao.PCGFilterConfigDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerDao;
import cn.com.duiba.goods.center.biz.dao.PlatformCouponGoodsDao;
import cn.com.duiba.goods.center.biz.entity.GoodsContentEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsContentService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.GoodsTagsService;
import cn.com.duiba.goods.center.biz.service.PCGCategoryGoodsService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PCGSellerGoodsService;
import cn.com.duiba.goods.center.biz.service.impl.RedisFilterCache;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PCGFilterConfigServiceImpl
implements PCGFilterConfigService {
    private static Logger LOGGER = LoggerFactory.getLogger(PCGFilterConfigServiceImpl.class);
    @Autowired
    private PCGFilterConfigDao pCGFilterConfigDao;
    @Autowired
    private PlatformCouponGoodsDao platformCouponGoodsDao;
    @Autowired
    private PCGCategoryDao pCGCategoryDao;
    @Autowired
    private PCGSellerDao pCGSellerDao;
    @Autowired
    private PCGSellerGoodsService pCGSellerGoodsService;
    @Autowired
    private PCGCategoryGoodsService pCGCategoryGoodsService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    private GoodsBatchCouponBackendBO goodsBatchCouponBackendBO;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private GoodsContentService goodsContentService;
    @Autowired
    private PCGUtilBO pCGUtilBO;
    @Autowired
    private GoodsTagsService goodsTagsService;

    @Override
    public List<PlatformCouponGoodsEntity> findGoodsFilterList(Long appId) {
        List<Long> pcgIds = this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, 1);
        if (pcgIds.isEmpty()) {
            return new ArrayList<PlatformCouponGoodsEntity>();
        }
        return this.platformCouponGoodsDao.selectByIds(pcgIds);
    }

    @Override
    public List<PCGCategoryEntity> findCategoryFilterList(Long appId) {
        List<Long> categoryIds = this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, 2);
        if (categoryIds.isEmpty()) {
            return new ArrayList<PCGCategoryEntity>();
        }
        return this.pCGCategoryDao.selectByIds(categoryIds);
    }

    @Override
    public List<PCGSellerEntity> findSellerFilterList(Long appId) {
        List<Long> sellerIds = this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, 3);
        if (sellerIds.isEmpty()) {
            return new ArrayList<PCGSellerEntity>();
        }
        return this.pCGSellerDao.selectByIds(sellerIds);
    }

    @Override
    public List<PCGFilterConfigDto> findCounponBelong(Long goodsId) {
        List<Long> categoryIds;
        PCGSellerEntity pCGSellerEntity;
        ArrayList<PCGFilterConfigDto> list = new ArrayList<PCGFilterConfigDto>();
        PCGFilterConfigDto pcd = new PCGFilterConfigDto();
        Long sellerGoods = this.pCGFilterConfigDao.selectGoodsSeller(goodsId);
        if (sellerGoods != null && (pCGSellerEntity = this.pCGSellerDao.select(sellerGoods)) != null) {
            pcd.setType(Integer.valueOf(3));
            pcd.setTargetId(pCGSellerEntity.getId());
            pcd.setTargetName(pCGSellerEntity.getName());
            list.add(pcd);
        }
        if ((categoryIds = this.pCGFilterConfigDao.selectGoodsCategory(goodsId)) != null && !categoryIds.isEmpty()) {
            List<PCGCategoryEntity> categorys = this.pCGCategoryDao.selectByIds(categoryIds);
            for (PCGCategoryEntity category : categorys) {
                pcd = new PCGFilterConfigDto();
                pcd.setType(Integer.valueOf(2));
                pcd.setTargetId(category.getId());
                pcd.setTargetName(category.getName());
                list.add(pcd);
            }
        }
        return list;
    }

    @Override
    public Long insert(long appId, int type, long targetId) {
        return this.pCGFilterConfigDao.insert(appId, type, targetId);
    }

    @Override
    public int delete(long appId, int type, long targetId) {
        return this.pCGFilterConfigDao.delete(appId, type, targetId);
    }

    @Override
    public PCGFilterConfigEntity select(Long id) {
        return this.pCGFilterConfigDao.select(id);
    }

    @Override
    public List<Long> selectPCGFilterTargetIds(Long appId, Integer type) {
        return this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, type);
    }

    @Override
    public List<PCGCategorySellerGoodsDto> selectPCGCategoryGoodsList(Long appId) {
        ArrayList<Long> pcgIds = new ArrayList<Long>();
        ArrayList<PCGFilterConfigBOImpl.PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGFilterConfigBOImpl.PCGIdAndPayLoad>();
        ArrayList<PCGCategorySellerGoodsDto> platformCouponGoodss = new ArrayList<PCGCategorySellerGoodsDto>();
        List<PCGCategoryEntity> pCGCategoryEntitys = this.pCGCategoryDao.selectAll();
        ArrayList<Long> catIds = new ArrayList<Long>();
        for (PCGCategoryEntity c : pCGCategoryEntitys) {
            catIds.add(c.getId());
        }
        List<PCGCategoryGoodsEntity> pCGCategoryGoodsEntity = this.pCGCategoryGoodsService.findAllGoodsByCateIds(catIds);
        for (PCGCategoryGoodsEntity cateGoods : pCGCategoryGoodsEntity) {
            pcgIds.add(cateGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGFilterConfigBOImpl.PCGIdAndPayLoad(cateGoods.getPcgId(), cateGoods.getPayload()));
        }
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        List<PlatformCouponGoodsEntity> ps = this.platformCouponGoodsDao.selectByIds(pcgIds);
        this.goodsTagsFilter(ps, appId);
        for (PlatformCouponGoodsEntity pce : ps) {
            if (this.pCGUtilBO.isInBlack(pce, appId) || 1 != pce.getPcgStatus() || pce.getDeleted().booleanValue()) continue;
            if (PCGFilterConfigServiceImpl.isOpen(1, pce.getSwitches().intValue())) {
                GoodsDirectionalConfigEntity gdce1 = directionals.get(appId + "-" + pce.getPcgId());
                GoodsDirectionalConfigEntity gdce2 = directionals.get("0-" + pce.getPcgId());
                if (gdce1 == null && gdce2 == null) continue;
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            psgd.setIconImage(pce.getIconImage());
            psgd.setPcgId(pce.getPcgId());
            psgd.setTitle(pce.getTitle());
            psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, pce.getPcgId()));
            if (platformCouponGoodss.contains(psgd)) continue;
            platformCouponGoodss.add(psgd);
        }
        return platformCouponGoodss;
    }

    @Override
    public List<PCGCategorySellerGoodsDto> selectPCGSellerGoodsList(Long appId) {
        List<PCGSellerEntity> pCGSellerEntitys = this.pCGSellerDao.selectAll();
        ArrayList<Long> sellerIds = new ArrayList<Long>();
        ArrayList<Long> pcgIds = new ArrayList<Long>();
        ArrayList<PCGCategorySellerGoodsDto> platformCouponGoodss = new ArrayList<PCGCategorySellerGoodsDto>();
        ArrayList<PCGFilterConfigBOImpl.PCGIdAndPayLoad> pCGIdAndPayLoads = new ArrayList<PCGFilterConfigBOImpl.PCGIdAndPayLoad>();
        for (PCGSellerEntity c : pCGSellerEntitys) {
            sellerIds.add(c.getId());
        }
        List<PCGSellerGoodsEntity> pCGSellerGoodsEntitys = this.pCGSellerGoodsService.findAllGoodsBySellerIds(sellerIds);
        for (PCGSellerGoodsEntity sellerGoods : pCGSellerGoodsEntitys) {
            pcgIds.add(sellerGoods.getPcgId());
            pCGIdAndPayLoads.add(new PCGFilterConfigBOImpl.PCGIdAndPayLoad(sellerGoods.getPcgId(), sellerGoods.getPayload()));
        }
        Map<String, GoodsDirectionalConfigEntity> directionals = this.goodsDirectionalConfigService.findByGoodsAll(GoodsTypeEnum.PLATFORM, pcgIds);
        List<PlatformCouponGoodsEntity> ps = this.platformCouponGoodsDao.selectByIds(pcgIds);
        this.goodsTagsFilter(ps, appId);
        for (PlatformCouponGoodsEntity pce : ps) {
            if (this.pCGUtilBO.isInBlack(pce, appId)) continue;
            if (1 == pce.getPcgStatus() && !pce.getDeleted().booleanValue() && PCGFilterConfigServiceImpl.isOpen(1, pce.getSwitches().intValue())) {
                GoodsDirectionalConfigEntity gdce1 = directionals.get(appId + "-" + pce.getPcgId());
                GoodsDirectionalConfigEntity gdce2 = directionals.get("0-" + pce.getPcgId());
                if (gdce1 == null && gdce2 == null) continue;
            }
            PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
            psgd.setIconImage(pce.getIconImage());
            psgd.setPcgId(pce.getPcgId());
            psgd.setTitle(pce.getTitle());
            psgd.setPayLoad(PCGFilterConfigBOImpl.setPayLoad(pCGIdAndPayLoads, pce.getPcgId()));
            platformCouponGoodss.add(psgd);
        }
        return platformCouponGoodss;
    }

    public static boolean isOpen(int bit, int switches) {
        int v = 1 << bit;
        int ret = switches & v;
        return ret != 0;
    }

    @Override
    public PCGCategorySellerGoodsDto findSellerGoodsInfo(long appId, long gid, Long consumerId, Long consumerCredits) throws Exception {
        PlatformCouponGoodsEntity pce = this.platformCouponGoodsDao.selectByPcgId(gid);
        GoodsContentEntity goods = this.goodsContentService.findByGoods(GoodsTypeEnum.PLATFORM, gid);
        if (pce == null || goods == null) {
            throw new Exception("\u627e\u4e0d\u5230 \u5bf9\u5e94\u7684 \u5e73\u53f0\u5238\u4fe1\u606f");
        }
        RedisFilterCache redisFilterCache = new RedisFilterCache(this.redisTemplate);
        List<Long> filterGoodsIds = (List<Long>)redisFilterCache.getFilterListCache(redisFilterCache.getFilterConfigRedisKey(appId, 1), Long.class);
        if (filterGoodsIds == null || filterGoodsIds.isEmpty()) {
            filterGoodsIds = this.pCGFilterConfigDao.selectPCGFilterTargetIds(appId, 1);
        }
        if (!filterGoodsIds.isEmpty()) {
            for (Long filterGoodsId : filterGoodsIds) {
                if (pce.getPcgId() - filterGoodsId != 0L) continue;
                throw new Exception("\u8be5\u5238 \u5df2\u88ab\u5f00\u53d1\u8005\u5c4f\u853d");
            }
        }
        PCGCategorySellerGoodsDto psgd = new PCGCategorySellerGoodsDto();
        if (1 != pce.getPcgStatus() || pce.getDeleted().booleanValue()) {
            throw new Exception("\u8be5\u5238\u5df2\u4e0b\u67b6");
        }
        ObjectUtil.convert((Object)pce, (Object)psgd);
        psgd.setIconImage(pce.getDetailImage());
        psgd.setDetail(goods.getContent());
        GoodsDirectionalConfigDto gc = new GoodsDirectionalConfigDto();
        gc.setStock(Long.valueOf(0L));
        psgd.setGoodsDirectionalConfigDto(gc);
        long pcgStock = this.goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pce.getPcgId());
        psgd.setStock(Long.valueOf(pcgStock));
        return psgd;
    }

    @Override
    public Map<Long, List<PCGFilterConfigDto>> findFilterCounponBelongs(Set<Long> catSet, Set<Long> sellerSet) {
        ArrayList<Long> categoryIds;
        PCGFilterConfigDto pcd = new PCGFilterConfigDto();
        HashMap<Long, List<PCGFilterConfigDto>> map = new HashMap<Long, List<PCGFilterConfigDto>>();
        ArrayList<Long> sellerIds = new ArrayList<Long>(sellerSet);
        if (!sellerIds.isEmpty()) {
            List<PCGSellerGoodsEntity> sellerGoods = this.pCGSellerGoodsService.findAllGoodsBySellerIds(sellerIds);
            for (PCGSellerGoodsEntity sellerGood : sellerGoods) {
                pcd = new PCGFilterConfigDto();
                pcd.setType(Integer.valueOf(3));
                pcd.setTargetId(sellerGood.getSellerId());
                ArrayList<PCGFilterConfigDto> l = (ArrayList<PCGFilterConfigDto>)map.get(sellerGood.getPcgId());
                if (l == null) {
                    l = new ArrayList<PCGFilterConfigDto>();
                    map.put(sellerGood.getPcgId(), l);
                }
                l.add(pcd);
            }
        }
        if (!(categoryIds = new ArrayList<Long>(catSet)).isEmpty()) {
            List<PCGCategoryGoodsEntity> cateGoods = this.pCGCategoryGoodsService.findAllGoodsByCateIds(categoryIds);
            for (PCGCategoryGoodsEntity cateGood : cateGoods) {
                pcd = new PCGFilterConfigDto();
                pcd.setType(Integer.valueOf(2));
                pcd.setTargetId(cateGood.getCategoryId());
                ArrayList<PCGFilterConfigDto> l = (ArrayList<PCGFilterConfigDto>)map.get(cateGood.getPcgId());
                if (l == null) {
                    l = new ArrayList<PCGFilterConfigDto>();
                    map.put(cateGood.getPcgId(), l);
                }
                l.add(pcd);
            }
        }
        return map;
    }

    @Override
    public void goodsTagsIdFilter(List<Long> pcgIds, Long appId) {
        Map<Long, String> pcgTagsMap = this.goodsTagsService.getPCGTagsMapByIds(pcgIds);
        List<String> appTags = this.goodsTagsService.getAppTags(appId);
        if (appTags.isEmpty()) {
            return;
        }
        Iterator<Long> iterator = pcgIds.iterator();
        while (iterator.hasNext()) {
            Long it = iterator.next();
            if (StringUtils.isBlank((String)pcgTagsMap.get(it))) continue;
            String[] pcgTags = pcgTagsMap.get(it).split(",");
            ArrayList<String> pcgTagList = new ArrayList<String>(Arrays.asList(pcgTags));
            pcgTagList.retainAll(appTags);
            if (pcgTagList.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Override
    public void goodsTagsFilter(List<PlatformCouponGoodsEntity> pcgs, Long appId) {
        Map<Long, String> pcgTagsMap = this.goodsTagsService.getPCGTagsMapByEntities(pcgs);
        List<String> appTags = this.goodsTagsService.getAppTags(appId);
        if (appTags.isEmpty()) {
            return;
        }
        Iterator<PlatformCouponGoodsEntity> iterator = pcgs.iterator();
        while (iterator.hasNext()) {
            PlatformCouponGoodsEntity it = iterator.next();
            if (StringUtils.isBlank((String)pcgTagsMap.get(it.getPcgId()))) continue;
            String[] pcgTags = pcgTagsMap.get(it.getPcgId()).split(",");
            ArrayList<String> pcgTaglist = new ArrayList<String>(Arrays.asList(pcgTags));
            pcgTaglist.retainAll(appTags);
            if (pcgTaglist.isEmpty()) continue;
            iterator.remove();
        }
    }
}

