/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.stock.impl;

import cn.com.duiba.goods.center.biz.service.stock.PcgDirectionalSalesVolumeService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pcgDirectionalSalesVolumeService")
public class PcgDirectionalSalesVolumeServiceImpl
implements PcgDirectionalSalesVolumeService {
    private static Logger LOG = LoggerFactory.getLogger(PcgDirectionalSalesVolumeServiceImpl.class);
    @Autowired
    private RemoteSaleLimitService remoteSaleLimitService;

    @Override
    public Long findSaleCountToday(long pcgId, long directionId) {
        DubboResult todaySales = this.remoteSaleLimitService.findSaleCountToday(Integer.valueOf(1), pcgId + "-" + directionId);
        if (!todaySales.isSuccess()) {
            LOG.error("remoteSaleLimitService.findSaleCountToday success=false ,relationId=" + pcgId + "-" + directionId + ",msg=" + todaySales.getMsg());
            return Long.MAX_VALUE;
        }
        return (Long)todaySales.getResult();
    }

    @Override
    public boolean addSaleToday(long pcgId, long directionId, String orderNum, int dayLimit) {
        DubboResult ret = this.remoteSaleLimitService.addSaleToday(Integer.valueOf(1), pcgId + "-" + directionId, orderNum, dayLimit);
        if (!ret.isSuccess()) {
            LOG.error("remoteSaleLimitService.addSaleToday success=false ,orderNum=" + orderNum + ", msg=" + ret.getMsg());
            return false;
        }
        if (!((Boolean)ret.getResult()).booleanValue()) {
            LOG.error("remoteSaleLimitService.addSaleToday result=false ,orderNum=" + orderNum);
            return false;
        }
        return true;
    }

    @Override
    public boolean rollbackSale(long pcgId, long directionId, String orderNum) {
        DubboResult ret = this.remoteSaleLimitService.rollbackSaleToday(Integer.valueOf(1), pcgId + "-" + directionId, orderNum);
        if (!ret.isSuccess()) {
            LOG.error("remoteSaleLimitService.rollbackSaleToday success=false,key=" + pcgId + "-" + directionId + ",orderNum=" + orderNum + ",msg=" + ret.getMsg());
            return false;
        }
        if (!((Boolean)ret.getResult()).booleanValue()) {
            LOG.error("remoteSaleLimitService.rollbackSaleToday result=false,orderNum=" + orderNum);
            return false;
        }
        return true;
    }
}

