/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchImportLogDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.bo.GoodsBatchCouponBackendBO;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchImportLogEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchImportLogService;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.util.IdSuffixTool;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.io.Files;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.beans.BeanCopier;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="goodsBatchCouponBackendBO")
public class GoodsBatchCouponBackendBOImpl
implements GoodsBatchCouponBackendBO {
    private static final Logger log = LoggerFactory.getLogger(GoodsBatchCouponBackendBOImpl.class);
    @Autowired
    protected GoodsCouponService goodsCouponService;
    @Autowired
    protected GoodsBatchService goodsBatchService;
    @Autowired
    protected PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private GoodsBatchImportLogService goodsBatchImportLogService;
    @Autowired
    private RemoteIDMakerBackendService remoteIDMakerBackendService;
    private ExecutorService es = Executors.newCachedThreadPool();
    private AtomicInteger concurrent = new AtomicInteger();
    private static BeanCopier GoodsBatchCopier = BeanCopier.create(GoodsBatchEntity.class, GoodsBatchDto.class, (boolean)false);
    private static BeanCopier GoodsCouponCopier = BeanCopier.create(GoodsCouponEntity.class, GoodsCouponDto.class, (boolean)false);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end) throws GoodsException {
        Long batchId = null;
        GoodsBatchEntity entity = this.goodsBatchService.findByStartDayAndDay(gtype, gid, start, end);
        if (entity != null) {
            batchId = entity.getId();
            if (entity.getStatus() != 4) throw new GoodsException(ErrorCode.E0404001);
            this.goodsBatchService.markBatchStatusNotUsed(entity.getId());
        } else {
            DubboResult stockRet = this.remoteStockBackendService.newStock(gid, 0L);
            if (!stockRet.isSuccess()) {
                throw new GoodsException(ErrorCode.E0203003.getErrorCode(), stockRet.getMsg());
            }
            batchId = this.goodsBatchService.createNormalBatch(gtype, gid, start, end, (Long)stockRet.getResult());
            if (GoodsTypeEnum.PLATFORM == gtype) {
                this.platformCouponGoodsService.editPlatformCouponType(gid, 0);
            }
        }
        this.goodsBatchService.refreshUsingBatch(gtype, gid);
        return batchId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String link, long stock) throws GoodsException {
        Long batchId = null;
        GoodsBatchEntity entity = this.goodsBatchService.findByStartDayAndDay(gtype, gid, start, end);
        if (entity != null) {
            batchId = entity.getId();
            if (entity.getStatus() != 4) throw new GoodsException(ErrorCode.E0404001);
            this.goodsBatchService.markBatchStatusNotUsed(entity.getId());
            this.goodsCouponService.updateLinkBatch(gtype, gid, batchId, link);
            DubboResult ret = this.remoteStockBackendService.increaseItemStock(entity.getStockId().longValue(), stock);
            if (!ret.isSuccess()) {
                throw new GoodsException(ErrorCode.E0203003.getErrorCode(), "\u589e\u52a0\u5e93\u5b58\u5931\u8d25");
            }
        } else {
            DubboResult stockRet = this.remoteStockBackendService.newStock(gid, stock);
            if (stockRet.isSuccess()) {
                batchId = this.goodsBatchService.createLinkBatch(gtype, gid, start, end, (Long)stockRet.getResult());
                if (GoodsTypeEnum.PLATFORM == gtype) {
                    this.platformCouponGoodsService.editPlatformCouponType(gid, 1);
                }
                this.goodsCouponService.importLinkCoupon(gtype, gid, batchId, this.getNewGoodsCouponId(gid), link);
            } else {
                log.error("newStock error, because of:" + stockRet.getMsg());
                throw new GoodsException(ErrorCode.E0203003.getErrorCode(), stockRet.getMsg());
            }
        }
        this.goodsBatchService.refreshUsingBatch(gtype, gid);
        return batchId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, String code, String password, long stock) throws GoodsException {
        Long batchId = null;
        GoodsBatchEntity entity = this.goodsBatchService.findByStartDayAndDay(gtype, gid, start, end);
        if (entity != null) {
            batchId = entity.getId();
            if (entity.getStatus() != 4) throw new GoodsException(ErrorCode.E0404001);
            this.goodsBatchService.markBatchStatusNotUsed(entity.getId());
            this.goodsCouponService.updateRepeatBatch(gtype, gid, batchId, code, password);
            DubboResult ret = this.remoteStockBackendService.increaseItemStock(entity.getStockId().longValue(), stock);
            if (!ret.isSuccess()) {
                throw new GoodsException(ErrorCode.E0203003.getErrorCode(), "\u589e\u52a0\u5e93\u5b58\u5931\u8d25");
            }
        } else {
            DubboResult stockRet = this.remoteStockBackendService.newStock(gid, stock);
            if (stockRet.isSuccess()) {
                batchId = this.goodsBatchService.createRepeatBatch(gtype, gid, start, end, (Long)stockRet.getResult());
                if (GoodsTypeEnum.PLATFORM == gtype) {
                    this.platformCouponGoodsService.editPlatformCouponType(gid, 2);
                }
                this.goodsCouponService.importRepeatCoupon(gtype, gid, batchId, this.getNewGoodsCouponId(gid), code, password);
                this.goodsBatchService.refreshUsingBatch(gtype, gid);
                return batchId;
            }
            log.error("newStock error, because of:" + stockRet.getMsg());
            throw new GoodsException(ErrorCode.E0203003.getErrorCode(), stockRet.getMsg());
        }
        this.goodsBatchService.refreshUsingBatch(gtype, gid);
        return batchId;
    }

    @Override
    public Boolean updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link, long changeStock) {
        DubboResult ret;
        boolean success = this.goodsCouponService.updateLinkBatch(gtype, gid, batchId, link);
        if (!success) {
            return success;
        }
        GoodsBatchEntity e = this.goodsBatchService.find(batchId);
        if (changeStock > 0L) {
            DubboResult ret2 = this.remoteStockBackendService.increaseItemStock(e.getStockId().longValue(), changeStock);
            if (!ret2.isSuccess()) {
                return false;
            }
            GoodsBatchEntity batch = this.goodsBatchService.find(batchId);
            if (batch.getStatus() == 3) {
                this.goodsBatchService.markBatchStatusNotUsed(batchId);
            }
        } else if (changeStock < 0L && !(ret = this.remoteStockBackendService.decreaseItemStock(e.getStockId().longValue(), changeStock * -1L)).isSuccess()) {
            return false;
        }
        this.goodsBatchService.getUsingBatch(gtype, gid);
        return true;
    }

    @Override
    public Boolean updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password, long changeStock) {
        DubboResult ret;
        boolean success = this.goodsCouponService.updateRepeatBatch(gtype, gid, batchId, code, password);
        if (!success) {
            return success;
        }
        GoodsBatchEntity e = this.goodsBatchService.find(batchId);
        if (changeStock > 0L) {
            DubboResult ret2 = this.remoteStockBackendService.increaseItemStock(e.getStockId().longValue(), changeStock);
            if (!ret2.isSuccess()) {
                return false;
            }
            GoodsBatchEntity batch = this.goodsBatchService.find(batchId);
            if (batch.getStatus() == 3) {
                this.goodsBatchService.markBatchStatusNotUsed(batchId);
            }
        } else if (changeStock < 0L && !(ret = this.remoteStockBackendService.decreaseItemStock(e.getStockId().longValue(), changeStock * -1L)).isSuccess()) {
            return false;
        }
        this.goodsBatchService.getUsingBatch(gtype, gid);
        return success;
    }

    @Override
    public List<GoodsBatchDto> findBatchs(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> list = this.goodsBatchService.findNotDeletedBatchs(gtype, gid);
        ArrayList<GoodsBatchDto> ret = new ArrayList<GoodsBatchDto>(list.size());
        for (GoodsBatchEntity e : list) {
            DubboResult totalStockRet;
            DubboResult stockRet;
            GoodsCouponEntity c;
            GoodsBatchDto dto = this.convert(e);
            if (e.getBatchType() == 1) {
                c = this.goodsCouponService.findOneByGoodsBatchId(gtype, gid, e.getId());
                if (c == null) continue;
                dto.setLink(c.getLink());
                if (e.getStockId() == null) {
                    dto.setStock(Long.valueOf(0L));
                    dto.setTotalStock(Long.valueOf(0L));
                } else {
                    stockRet = this.remoteStockBackendService.find(e.getStockId().longValue());
                    dto.setStock((Long)stockRet.getResult());
                    totalStockRet = this.remoteStockBackendService.findTotalStock(e.getStockId().longValue());
                    dto.setTotalStock((Long)totalStockRet.getResult());
                }
            } else if (e.getBatchType() == 2) {
                c = this.goodsCouponService.findOneByGoodsBatchId(gtype, gid, e.getId());
                if (c == null) continue;
                dto.setCode(c.getCode());
                dto.setPassword(c.getPassword());
                if (e.getStockId() == null) {
                    dto.setStock(Long.valueOf(0L));
                    dto.setTotalStock(Long.valueOf(0L));
                } else {
                    stockRet = this.remoteStockBackendService.find(e.getStockId().longValue());
                    dto.setStock((Long)stockRet.getResult());
                    totalStockRet = this.remoteStockBackendService.findTotalStock(e.getStockId().longValue());
                    dto.setTotalStock((Long)totalStockRet.getResult());
                }
            } else if (e.getBatchType() == 0) {
                if (e.getStockId() == null) {
                    dto.setStock(Long.valueOf(0L));
                    dto.setTotalStock(Long.valueOf(0L));
                } else {
                    DubboResult stockRet2 = this.remoteStockBackendService.find(e.getStockId().longValue());
                    dto.setStock((Long)stockRet2.getResult());
                    DubboResult totalStockRet2 = this.remoteStockBackendService.findTotalStock(e.getStockId().longValue());
                    dto.setTotalStock((Long)totalStockRet2.getResult());
                }
            }
            ret.add(dto);
        }
        return ret;
    }

    @Override
    public Long importNormalCoupons(final GoodsTypeEnum gtype, final long gid, final Long batchId, final String downloadUrl) {
        GoodsBatchImportLogEntity e = new GoodsBatchImportLogEntity();
        e.setGoodsBatchId(batchId);
        final Long importLogId = this.goodsBatchImportLogService.insert(e);
        int data = this.concurrent.incrementAndGet();
        if (data > 5) {
            this.concurrent.decrementAndGet();
            throw new RuntimeGoodsException(ErrorCode.E9999999);
        }
        this.es.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String l;
                    String[] ss;
                    List lines = GoodsBatchCouponBackendBOImpl.downloadTxt(downloadUrl);
                    ArrayList<GoodsCouponDao.CouponFormat> cfs = new ArrayList<GoodsCouponDao.CouponFormat>(lines.size());
                    HashMap<String, String> couponMap = new HashMap<String, String>(lines.size());
                    List goodsCouponIds = GoodsBatchCouponBackendBOImpl.this.getNewBatchGoodsCouponIds(gid, lines.size());
                    String split = "\t";
                    for (int i = 0; i < lines.size() && (ss = (l = (String)lines.get(i)).split(split)).length != 0; ++i) {
                        String code = ss[0].trim();
                        String password = "";
                        if (ss.length == 2) {
                            password = ss[1];
                        }
                        couponMap.put(code, password);
                        GoodsCouponDao.CouponFormat cf = new GoodsCouponDao.CouponFormat();
                        cf.setCode(code);
                        cf.setGoodsCouponId((Long)goodsCouponIds.get(i));
                        cf.setPassword(password);
                        cfs.add(cf);
                    }
                    GoodsBatchEntity batch = GoodsBatchCouponBackendBOImpl.this.goodsBatchService.find(batchId);
                    Integer successCount = GoodsBatchCouponBackendBOImpl.this.goodsCouponService.importNormalCoupons(batch, cfs);
                    Integer failCount = cfs.size() - successCount;
                    GoodsBatchCouponBackendBOImpl.this.goodsBatchImportLogService.updateSuccessAndFail(importLogId, successCount, failCount);
                    if (successCount > 0 && batch.getStatus() == 3) {
                        GoodsBatchCouponBackendBOImpl.this.goodsBatchService.markBatchStatusNotUsed(batchId);
                    }
                    GoodsBatchCouponBackendBOImpl.this.goodsBatchService.getUsingBatch(gtype, gid);
                }
                catch (Exception e) {
                    log.error("importNormalCoupons in thread error", (Throwable)e);
                }
                finally {
                    GoodsBatchCouponBackendBOImpl.this.concurrent.decrementAndGet();
                }
            }
        });
        return importLogId;
    }

    @Override
    public GoodsBatchImportLogDto findBatchImportLog(Long goodsBatchImportLogId) {
        GoodsBatchImportLogEntity e = this.goodsBatchImportLogService.select(goodsBatchImportLogId);
        if (e != null) {
            GoodsBatchImportLogDto dto = new GoodsBatchImportLogDto();
            dto.setId(e.getId());
            dto.setFailCount(e.getFailCount());
            dto.setGoodsBatchId(e.getGoodsBatchId());
            dto.setSuccessCount(e.getSuccessCount());
            return dto;
        }
        return null;
    }

    @Override
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        boolean success = this.goodsBatchService.deleteBatch(gtype, gid, batchId);
        return success;
    }

    @Override
    public Page<GoodsCouponDto> findPage(GoodsTypeEnum gtype, long gid, long batchId, int pageSize, int pageIndex) {
        GoodsBatchEntity batch = this.goodsBatchService.find(batchId);
        DubboResult stockRet = this.remoteStockBackendService.findTotalStock(batch.getStockId().longValue());
        if (!stockRet.isSuccess()) {
            Page ret = new Page(pageSize, pageIndex);
            return ret;
        }
        Page<GoodsCouponEntity> page = this.goodsCouponService.findPage(gtype, gid, batchId, pageSize, pageIndex, ((Long)stockRet.getResult()).intValue());
        Page ret = new Page(pageSize, pageIndex);
        ret.setTotalPages(page.getTotalPages());
        ret.setTotalCount(page.getTotalCount());
        ArrayList<GoodsCouponDto> list = new ArrayList<GoodsCouponDto>(page.getList().size());
        for (GoodsCouponEntity e : page.getList()) {
            list.add(this.convert(e));
        }
        ret.setList(list);
        return ret;
    }

    @Override
    public GoodsBatchDto findBatchStock(GoodsTypeEnum gtype, long gid, long batchId) {
        GoodsBatchEntity e = this.goodsBatchService.find(batchId);
        GoodsBatchDto dto = this.convert(e);
        if (e.getStockId() == null) {
            dto.setStock(Long.valueOf(0L));
            dto.setTotalStock(Long.valueOf(0L));
            return dto;
        }
        DubboResult stockRet = this.remoteStockBackendService.find(e.getStockId().longValue());
        dto.setStock((Long)stockRet.getResult());
        DubboResult totalStockRet = this.remoteStockBackendService.findTotalStock(e.getStockId().longValue());
        dto.setTotalStock((Long)totalStockRet.getResult());
        if (!totalStockRet.isSuccess() || !stockRet.isSuccess()) {
            throw new RuntimeGoodsException(ErrorCode.E9999999);
        }
        dto.setStock((Long)stockRet.getResult());
        dto.setTotalStock((Long)totalStockRet.getResult());
        return dto;
    }

    @Override
    public List<GoodsCouponDto> findCouponByCode(GoodsTypeEnum gtype, long gid, long batchId, String code) {
        List<GoodsCouponEntity> list = this.goodsCouponService.searchByCode(gtype, gid, batchId, code);
        ArrayList<GoodsCouponDto> ret = new ArrayList<GoodsCouponDto>();
        for (GoodsCouponEntity e : list) {
            ret.add(this.convert(e));
        }
        return ret;
    }

    @Override
    public GoodsCouponDto findCoupon(GoodsTypeEnum gtype, long gid, long couponId) {
        GoodsCouponEntity entity = this.goodsCouponService.find(couponId);
        if (entity != null) {
            return this.convert(entity);
        }
        return null;
    }

    @Override
    public Boolean deleteUnusedCoupon(GoodsTypeEnum gtype, long gid, Long couponId, Long batchId) {
        boolean del = this.goodsCouponService.deleteUnusedCoupon(gtype, gid, couponId, batchId);
        if (del) {
            GoodsBatchEntity e = this.goodsBatchService.find(batchId);
            this.remoteStockBackendService.decreaseItemStock(e.getStockId().longValue(), 1L);
        }
        return del;
    }

    @Override
    public Boolean deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId) {
        GoodsBatchEntity e = this.goodsBatchService.find(batchId);
        return this.goodsCouponService.deleteBatchUnusedCoupons(e);
    }

    private Long getNewGoodsCouponId(Long gid) {
        List<Long> ids = this.getNewBatchGoodsCouponIds(gid, 1);
        return ids.get(0);
    }

    private List<Long> getNewBatchGoodsCouponIds(Long gid, int count) {
        DubboResult ret = this.remoteIDMakerBackendService.getBatchNextID(null, (long)count);
        if (ret.isSuccess()) {
            ArrayList<Long> ids = new ArrayList<Long>(count);
            for (int i = 0; i < count; ++i) {
                ids.add(Long.valueOf((Long)ret.getResult() + (long)i + IdSuffixTool.getTableSuffix(gid)));
            }
            return ids;
        }
        throw new RuntimeGoodsException(ErrorCode.E0203001);
    }

    private GoodsBatchDto convert(GoodsBatchEntity e) {
        GoodsBatchDto d = new GoodsBatchDto();
        GoodsBatchCopier.copy((Object)e, (Object)d, null);
        return d;
    }

    private GoodsCouponDto convert(GoodsCouponEntity e) {
        GoodsCouponDto d = new GoodsCouponDto();
        GoodsCouponCopier.copy((Object)e, (Object)d, null);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> downloadTxt(String url) {
        File f = null;
        try {
            f = File.createTempFile("coupon-", "txt");
            URL httpurl = new URL(url);
            FileUtils.copyURLToFile((URL)httpurl, (File)f);
            List list = Files.readLines((File)f, (Charset)Charset.defaultCharset());
            return list;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        finally {
            if (f != null && !f.delete()) {
                log.error("delete file fail");
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Boolean deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, List<Long> couponIds) {
        return this.goodsCouponService.deleteBatchUnusedCoupons(gtype, gid, batchId, couponIds);
    }

    @Override
    public List<GoodsCouponDto> findUnusedCoupons(GoodsTypeEnum gtype, long gid, Long batchId, int limit) {
        List<GoodsCouponEntity> entity = this.goodsCouponService.findUnusedCoupons(gtype, gid, batchId, limit);
        ArrayList<GoodsCouponDto> ret = new ArrayList<GoodsCouponDto>();
        for (GoodsCouponEntity e : entity) {
            ret.add(this.convert(e));
        }
        return ret;
    }

    @Override
    public Boolean updateValidDate(GoodsTypeEnum gtype, long acgId, long batchId, Date startDay, Date endDay) {
        return this.goodsBatchService.updateValidDate(gtype, acgId, batchId, startDay, endDay);
    }
}

