/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.util.ConsumeStockTypeUtil;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponBO")
public class GoodsCouponBOImpl
implements GoodsCouponBO {
    private static Logger log = LoggerFactory.getLogger(GoodsCouponBOImpl.class);
    @Autowired
    @Qualifier(value="goodsCouponService4Speed")
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteStockService remoteStockService;
    private LoadingCache<Long, Lock> lockmap = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, Lock>(){

        public Lock load(Long key) throws Exception {
            return new ReentrantLock();
        }
    });

    @Override
    public GoodsCouponEntity takeCoupon(GoodsTypeEnum gtype, long gid, long consumerId, String bizNum) {
        GoodsBatchEntity using = this.goodsBatchService.getUsingBatch(gtype, gid);
        if (using == null) {
            boolean saleout = this.fastCheckSaleout(gtype, gid);
            if (!saleout) {
                using = this.retryLockRefreshBatchUsing(gtype, gid);
            }
            if (using == null) {
                return null;
            }
        }
        return this.getCouponInCycle(using, consumerId, bizNum);
    }

    /*
     * Exception decompiling
     */
    private GoodsCouponEntity getCouponInCycle(GoodsBatchEntity using, long consumerId, String bizNum) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoodsBatchEntity retryLockRefreshBatchUsing(GoodsTypeEnum gtype, long gid) {
        Lock lock = (Lock)this.lockmap.getUnchecked((Object)gid);
        if (lock != null && lock.tryLock()) {
            try {
                GoodsBatchEntity goodsBatchEntity = this.forceGetUsingBatch(gtype, gid);
                return goodsBatchEntity;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    private boolean fastCheckSaleout(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
        boolean saleout = true;
        for (GoodsBatchEntity e : batchs) {
            if (e.getStatus() != 1 && e.getStatus() != 2) continue;
            saleout = false;
            break;
        }
        return saleout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoodsBatchEntity forceGetUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)(this.getClass().getSimpleName() + ".forceGetUsingBatch"));
            List<GoodsBatchEntity> batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
            for (GoodsBatchEntity e : batchs) {
                DubboResult stockRet = this.remoteStockService.find(e.getStockId().longValue());
                if (!stockRet.isSuccess()) {
                    log.error("remoteStockService.find fail ,msg=" + stockRet.getMsg());
                    continue;
                }
                if ((Long)stockRet.getResult() > 0L) continue;
                this.goodsBatchService.markBatchStatusUsed(e.getId());
            }
            batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> backups = new ArrayList<GoodsBatchEntity>();
            Date min = null;
            for (GoodsBatchEntity e : batchs) {
                if (e.getStatus() != 1 && e.getStatus() != 2) continue;
                backups.add(e);
                if (min == null) {
                    min = e.getStartDay();
                    continue;
                }
                if (min.getTime() <= e.getStartDay().getTime()) continue;
                min = e.getStartDay();
            }
            for (GoodsBatchEntity e : backups) {
                if (!e.getStartDay().equals(min)) continue;
                this.goodsBatchService.markBatchStatusUsing(e.getId());
                GoodsBatchEntity goodsBatchEntity = this.goodsBatchService.find(e.getId());
                return goodsBatchEntity;
            }
            GoodsBatchEntity goodsBatchEntity = null;
            return goodsBatchEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public void completeCoupon(Long couponId, long orderId) {
        this.goodsCouponService.completeCoupon(couponId, orderId);
    }

    @Override
    public Boolean rollbackCoupon(Long couponId, String bizNum) {
        Boolean succ;
        GoodsCouponEntity coupon = this.goodsCouponService.find(couponId);
        long goodsBatchId = coupon.getGoodsBatchId();
        GoodsBatchEntity batch = this.goodsBatchService.find(goodsBatchId);
        if (batch.getBatchType() == 0 && !(succ = this.goodsCouponService.rollbackNormalCoupon(couponId)).booleanValue()) {
            return succ;
        }
        DubboResult stockRet = this.remoteStockService.rollbackStock(ConsumeStockTypeUtil.getConsumeStockTypes(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype())).getType(), bizNum);
        if (!stockRet.isSuccess()) {
            log.error("remoteStockService.rollbackStock fail,couponId=" + couponId + ",bizNum=" + bizNum);
            return false;
        }
        if (((Boolean)stockRet.getResult()).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public GoodsCouponEntity findCoupon(Long goodsCouponId) {
        return this.goodsCouponService.find(goodsCouponId);
    }

    @Override
    public Long findGoodsStock(GoodsTypeEnum gtype, long gid) {
        return this.goodsBatchService.getSumBatchStockBatch(gtype, gid);
    }

    @Override
    public List<GoodsStockDto> findGoodsStockByBatch(List<GoodsStockDto> goodsDtos) {
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        if (goodsDtos == null) {
            return stocks;
        }
        for (GoodsStockDto goods : goodsDtos) {
            GoodsStockDto dto = new GoodsStockDto();
            dto.setGtype(goods.getGtype());
            dto.setGid(goods.getGid());
            dto.setStock(this.findGoodsStock(goods.getGtype(), goods.getGid()));
            stocks.add(dto);
        }
        return stocks;
    }

    @Override
    public GoodsBatchEntity findBatch(Long goodsBatchId) {
        return this.goodsBatchService.find(goodsBatchId);
    }

    @Override
    public GoodsBatchEntity findUsingBatch(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> batchs = this.goodsBatchService.findNormalBatchs(gtype, gid);
        for (GoodsBatchEntity gd : batchs) {
            if (gd.getStatus() != 2) continue;
            return gd;
        }
        return null;
    }
}

