/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.enums.CouponType;
import cn.com.duiba.goods.center.biz.dao.GoodsBatchDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponRetrieveLogEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponRetrieveLogService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.util.AppendUploadUtil;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GoodsBatchServiceImpl
implements GoodsBatchService {
    private static Logger log = LoggerFactory.getLogger(GoodsBatchServiceImpl.class);
    @Autowired
    private GoodsBatchDao goodsBatchDao;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private GoodsCouponRetrieveLogService goodsCouponRetrieveLogService;
    @Autowired
    private GoodsCouponService goodsCouponService;
    private static final long perRetrieveGoodsCoupon = 999L;
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Date date;
    private Long position = 0L;
    private static final String fileUrlPrefix = "http://yun.duiba.com.cn/";
    @Autowired
    private AppendUploadUtil appendUploadUtil;

    @Override
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay, Long stockId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDay = sdf.parse(sdf.format(startDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        try {
            endDay = sdf.parse(sdf.format(endDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Normal, startDay, endDay, stockId);
    }

    @Override
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay, Long stockId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDay = sdf.parse(sdf.format(startDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        try {
            endDay = sdf.parse(sdf.format(endDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Link, startDay, endDay, stockId);
    }

    @Override
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date startDay, Date endDay, Long stockId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDay = sdf.parse(sdf.format(startDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        try {
            endDay = sdf.parse(sdf.format(endDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        return this.goodsBatchDao.insert(gtype, gid, CouponType.Repeat, startDay, endDay, stockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoodsBatchEntity> findNormalBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchServiceImpl.findNormalBatchs");
            List<GoodsBatchEntity> list = this.goodsBatchDao.selectNotDeletedNotExpiredGtypeGid(gtype, gid);
            return list;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoodsBatchEntity> findNotDeletedBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchServiceImpl.findNotDeletedBatchs");
            List<GoodsBatchEntity> list = this.goodsBatchDao.selectNotDeletedByGtypeGid(gtype, gid);
            return list;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        int ret;
        GoodsBatchEntity e = this.goodsBatchDao.select(batchId);
        if (e.getImporting().booleanValue()) {
            return false;
        }
        if (e.getBatchType() == 0) {
            boolean existUsedCoupon = this.goodsCouponService.findBatchExsitUsedCoupon(gtype, gid, batchId);
            if (existUsedCoupon) {
                return false;
            }
        } else {
            DubboResult stockRet = this.remoteStockBackendService.find(e.getStockId().longValue());
            DubboResult totalStockRet = this.remoteStockBackendService.findTotalStock(e.getStockId().longValue());
            if (totalStockRet.isSuccess() && stockRet.isSuccess()) {
                Long totalStock;
                Long stock = (Long)stockRet.getResult();
                if (stock != (totalStock = (Long)stockRet.getResult())) {
                    return false;
                }
            } else {
                throw new RuntimeGoodsException(ErrorCode.E9999999);
            }
        }
        if ((ret = this.goodsBatchDao.deleteBatch(gtype, gid, batchId)) == 1) {
            return true;
        }
        return false;
    }

    @Override
    public GoodsBatchEntity find(Long goodsBatchId) {
        return this.goodsBatchDao.select(goodsBatchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GoodsBatchEntity getUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            Object stockRet;
            DBTimeProfile.enter((String)(this.getClass().getSimpleName() + ".refreshBatchUsing"));
            List<GoodsBatchEntity> batchs = this.findNormalBatchs(gtype, gid);
            for (GoodsBatchEntity e : batchs) {
                stockRet = this.remoteStockService.find(e.getStockId().longValue());
                if (!stockRet.isSuccess()) {
                    log.error("remoteStockService.find fail ,msg=" + stockRet.getMsg());
                    continue;
                }
                if ((Long)stockRet.getResult() > 0L) continue;
                this.goodsBatchDao.updateStatusUsed(e.getId());
                e.setStatus(3);
            }
            for (GoodsBatchEntity e : batchs) {
                if (e.getStatus() != 2) continue;
                stockRet = e;
                return stockRet;
            }
            batchs = this.findNormalBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> backups = new ArrayList<GoodsBatchEntity>();
            Date min = null;
            for (GoodsBatchEntity e : batchs) {
                if (e.getStatus() != 1) continue;
                backups.add(e);
                if (min == null) {
                    min = e.getStartDay();
                    continue;
                }
                if (min.getTime() <= e.getStartDay().getTime()) continue;
                min = e.getStartDay();
            }
            for (GoodsBatchEntity e : backups) {
                if (!e.getStartDay().equals(min)) continue;
                this.goodsBatchDao.updateStatusUsing(e.getId());
                GoodsBatchEntity goodsBatchEntity = this.find(e.getId());
                return goodsBatchEntity;
            }
            GoodsBatchEntity goodsBatchEntity = null;
            return goodsBatchEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Long getOrigionTotalBatchStock(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchServiceImpl.getOrigionTotalBatchStock");
            GoodsBatchEntity batch = this.goodsBatchDao.select(goodsBatchId);
            if (batch.getStockId() == null) {
                Long l = 0L;
                return l;
            }
            DubboResult ret = this.remoteStockBackendService.findTotalStock(batch.getStockId().longValue());
            if (ret.isSuccess()) {
                Long l = (Long)ret.getResult();
                return l;
            }
            throw new RuntimeGoodsException(ErrorCode.E0203003);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getSumBatchStock(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> list = this.findNormalBatchs(gtype, gid);
        long total = 0L;
        for (GoodsBatchEntity e : list) {
            if (e.getStatus() == 4 || e.getStatus() == 3) continue;
            try {
                DBTimeProfile.enter((String)"GoodsBatchServiceImpl.getSumBatchStock");
                DubboResult stockRet = this.remoteStockService.find(e.getStockId().longValue());
                if (!stockRet.isSuccess()) {
                    log.error("remoteStockService.find error,msg=" + stockRet.getMsg());
                    total += 0L;
                    continue;
                }
                total += ((Long)stockRet.getResult()).longValue();
            }
            finally {
                DBTimeProfile.release();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getSumBatchStockBatch(GoodsTypeEnum gtype, long gid) {
        long total = 0L;
        ArrayList<Long> stockIds = new ArrayList<Long>();
        try {
            DBTimeProfile.enter((String)"findNormalBatchs");
            List<GoodsBatchEntity> list = this.findNormalBatchs(gtype, gid);
            for (GoodsBatchEntity goodsBatchEntity : list) {
                if (goodsBatchEntity.getStatus() == 4 || goodsBatchEntity.getStatus() == 3) continue;
                stockIds.add(goodsBatchEntity.getStockId());
            }
        }
        finally {
            DBTimeProfile.release();
        }
        try {
            DBTimeProfile.enter((String)"remoteStockService.findBatch");
            if (stockIds.size() > 0) {
                DubboResult stockRet = this.remoteStockService.findBatch(stockIds);
                if (!stockRet.isSuccess()) {
                    log.error("remoteStockService.findBatch error,msg=" + stockRet.getMsg());
                }
                for (Map.Entry entry : ((Map)stockRet.getResult()).entrySet()) {
                    total += ((Long)entry.getValue()).longValue();
                }
            }
        }
        finally {
            DBTimeProfile.release();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getTotalAllBatchStock(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"GoodsBatchServiceImpl.getTotalAllBatchStock");
            List<GoodsBatchEntity> list = this.findNotDeletedBatchs(gtype, gid);
            long total = 0L;
            for (GoodsBatchEntity e : list) {
                if (e.getStatus() == 4) continue;
                total += this.getOrigionTotalBatchStock(gtype, gid, e.getId()).longValue();
            }
            Long l = total;
            return l;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public void markBatchStatusUsed(long batchId) {
        this.goodsBatchDao.updateStatusUsed(batchId);
    }

    @Override
    public void markBatchStatusUsing(long batchId) {
        this.goodsBatchDao.updateStatusUsing(batchId);
    }

    @Override
    public void markBatchStatusNotUsed(long batchId) {
        this.goodsBatchDao.updateStatusNotUsed(batchId);
    }

    @Override
    public Boolean updateValidDate(GoodsTypeEnum gtype, long gid, long batchId, Date startDay, Date endDay) {
        if (this.goodsBatchDao.updateValidDate(batchId, startDay = new DateTime((Object)startDay).withTimeAtStartOfDay().toDate(), endDay = new DateTime((Object)endDay).withTimeAtStartOfDay().toDate()) == 1) {
            return true;
        }
        return false;
    }

    @Override
    public boolean updateGoodsType(GoodsTypeEnum gtype, long gid, int dstType) {
        if (gtype.equals((Object)GoodsTypeEnum.ADVERT)) {
            int row = this.goodsBatchDao.updateBatchType(gid, dstType);
            return row >= 1;
        }
        return false;
    }

    @Override
    public Boolean physicalDeleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        int row = this.goodsBatchDao.physicalDeleteBatch(gtype, gid, batchId);
        if (row >= 1) {
            return true;
        }
        return false;
    }

    @Override
    public List<GoodsBatchEntity> findGoodsBatchs(GoodsTypeEnum gtype, List<Long> gids) {
        return this.goodsBatchDao.selectGoodsBatchs(gtype, gids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)(this.getClass().getSimpleName() + ".refreshBatchUsing"));
            List<GoodsBatchEntity> batchs = this.findNormalBatchs(gtype, gid);
            for (GoodsBatchEntity e : batchs) {
                if (e.getStatus() != 2) continue;
                return;
            }
            batchs = this.findNormalBatchs(gtype, gid);
            ArrayList<GoodsBatchEntity> backups = new ArrayList<GoodsBatchEntity>();
            Date min = null;
            for (GoodsBatchEntity e : batchs) {
                if (e.getStatus() != 1) continue;
                backups.add(e);
                if (min == null) {
                    min = e.getStartDay();
                    continue;
                }
                if (min.getTime() <= e.getStartDay().getTime()) continue;
                min = e.getStartDay();
            }
            for (GoodsBatchEntity e : backups) {
                if (!e.getStartDay().equals(min)) continue;
                this.goodsBatchDao.updateStatusUsing(e.getId());
                return;
            }
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Long retrieveGoodsBatch(final GoodsTypeEnum gtype, final Long gid, final Long batchId, final Long count) throws Exception {
        if (!this.getBatchLock(batchId, gid, gtype)) {
            throw new Exception("\u6279\u6b21\u5df2\u88ab\u9501");
        }
        final GoodsBatchEntity batch = this.find(batchId);
        Long rst = null;
        if (batch == null) {
            throw new Exception("\u6279\u6b21\u4e0d\u5b58\u5728");
        }
        final int oriStatus = batch.getStatus();
        if (1 != oriStatus && 2 != oriStatus) {
            throw new Exception("[\u5df2\u4f7f\u7528,\u672a\u4f7f\u7528]\u7684\u6279\u6b21\u624d\u80fd\u56de\u6536");
        }
        this.date = new Date();
        try {
            this.markBatchStatusUsed(batchId);
            final Long count1 = rst = this.createRetrieveLog(gtype, gid, batchId, 0, 0, "");
            executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        GoodsBatchServiceImpl.this.doRetrieveGoodsCoupon(batch, oriStatus, gtype, gid, batchId, count, count1);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                    finally {
                        GoodsBatchServiceImpl.this.updateToOriStatus(batchId, oriStatus);
                        GoodsBatchServiceImpl.this.releaseBatchLock(batchId, gid, gtype);
                    }
                }
            });
        }
        catch (Exception e) {
            this.updateToOriStatus(batchId, oriStatus);
            log.error("\u56de\u6536\u6279\u6b21\u51fa\u9519:", (Throwable)e);
            throw e;
        }
        return rst;
    }

    @Override
    public boolean getBatchLock(Long goodsBatchId, Long gid, GoodsTypeEnum gtype) {
        return false;
    }

    @Override
    public void releaseBatchLock(Long goodsBatchId, Long gid, GoodsTypeEnum gtype) {
    }

    private void updateToOriStatus(Long batchId, int oriStatus) {
        if (oriStatus == 1) {
            this.markBatchStatusNotUsed(batchId);
        } else if (oriStatus == 2) {
            this.markBatchStatusUsing(batchId);
        }
    }

    private void doRetrieveGoodsCoupon(GoodsBatchEntity batch, int oriStatus, GoodsTypeEnum gtype, Long gid, Long batchId, Long count, Long logid) throws Exception {
        int successRetrieveCount = 0;
        this.position = 0L;
        String filePath = this.getFileName(gid, batchId);
        try {
            DubboResult dubboResult = this.remoteStockService.find(batch.getStockId().longValue());
            if (dubboResult.isSuccess()) {
                Long stockNum = (Long)dubboResult.getResult();
                if (stockNum != null) {
                    if (stockNum == 0L) {
                        log.error("\u5e93\u5b58\u4e3a0");
                        this.goodsCouponRetrieveLogService.updateStatusFail(logid);
                        throw new Exception("\u5e93\u5b58\u4e3a0");
                    }
                    if (stockNum < count) {
                        count = stockNum;
                    }
                } else {
                    log.error("\u5e93\u5b58\u4e0d\u5b58\u5728");
                    this.goodsCouponRetrieveLogService.updateStatusFail(logid);
                    throw new Exception("\u5e93\u5b58\u4e0d\u5b58\u5728");
                }
            }
            long forCount = this.caculateForCount(count);
            String key = filePath + ".txt";
            this.appendUploadUtil.setKey(key);
            boolean isLastPage = false;
            List<GoodsCouponEntity> list = null;
            if (forCount == 1L) {
                list = this.goodsCouponService.findPageByStatus(gtype, gid, batchId, 0, 0, (int)count.longValue());
                isLastPage = true;
                successRetrieveCount += this.deleteGoodsCoupons(gid, list, logid, isLastPage);
            } else {
                try {
                    int i = 0;
                    while ((long)i < forCount) {
                        if ((long)i == forCount - 1L) {
                            list = this.goodsCouponService.findPageByStatus(gtype, gid, batchId, 0, 0, (int)(count - (long)successRetrieveCount));
                            isLastPage = true;
                        } else {
                            list = this.goodsCouponService.findPageByStatus(gtype, gid, batchId, 0, 0, 999);
                        }
                        successRetrieveCount += this.deleteGoodsCoupons(gid, list, logid, isLastPage);
                        ++i;
                    }
                }
                catch (Exception e) {
                    log.error("\u5206\u9875\u56de\u6536\u6279\u6b21\u51fa\u9519", (Throwable)e);
                }
            }
            this.completeRetrieve(gid, batchId, count, batch, successRetrieveCount, logid, key);
            log.info("\u6210\u529f\u56de\u6536\u5238\u7801\u603b\u6570" + successRetrieveCount + "\u6761");
        }
        catch (Exception e) {
            log.error("\u56de\u6536\u5238\u7801\u5931\u8d25\u3002", (Throwable)e);
            throw e;
        }
    }

    private int deleteGoodsCoupons(Long gid, List<GoodsCouponEntity> list, Long logid, boolean isLastPage) {
        int rst = 0;
        if (!CollectionUtils.isEmpty(list)) {
            log.info("\u5206\u9875\u56de\u6536\u5238\u7801\u6570\u91cf:" + list.size());
            try {
                List<Long> deleteIds = this.appendContenToOss(list, isLastPage);
                rst = this.goodsCouponService.deleteGoodsCouponByIds(gid, deleteIds);
            }
            catch (Exception e) {
                log.error("appendContenToOss, deleteGoodsCouponByIds", (Throwable)e);
                rst = 0;
            }
        } else {
            log.info("\u6ca1\u6709\u53ef\u56de\u6536\u7684\u5238\u7801");
        }
        return rst;
    }

    private void completeRetrieve(Long gid, Long batchId, Long count, GoodsBatchEntity batch, int successRetrieveCount, Long logId, String filePath) {
        this.remoteStockBackendService.decreaseItemStock(batch.getStockId().longValue(), (long)successRetrieveCount);
        this.updateLogStatus(logId, successRetrieveCount, count, filePath);
    }

    private void updateLogStatus(Long logId, int successRetrieveCount, Long count, String fileUrl) {
        String url = fileUrlPrefix + fileUrl;
        log.info("update the fileUrl to the tb_goods_coupon_retrieve_log " + url);
        if (successRetrieveCount != 0 && count == (long)successRetrieveCount) {
            this.goodsCouponRetrieveLogService.updateStatusSuccess(logId, url, successRetrieveCount);
        } else if (successRetrieveCount != 0 && count > (long)successRetrieveCount) {
            this.goodsCouponRetrieveLogService.updateStatusPart(logId, url, successRetrieveCount);
        }
    }

    private long caculateForCount(Long count) {
        long forCount = 0L;
        forCount = count % 999L == 0L ? count / 999L : count / 999L + 1L;
        return forCount;
    }

    private BufferedWriter getBufferedWriter(File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
        return writer;
    }

    private String getFileName(Long gid, Long batchId) {
        return "tuia/manager/coupon-retrieve/" + gid + "_" + batchId + "_" + this.date.getTime();
    }

    private Long createRetrieveLog(GoodsTypeEnum gtype, Long gid, Long batchId, int successRetrieveCount, Integer retrieveStatus, String filePath) {
        GoodsCouponRetrieveLogEntity entity = new GoodsCouponRetrieveLogEntity();
        entity.setBatchId(batchId);
        entity.setGid(gid);
        entity.setStatus(retrieveStatus);
        entity.setGoodsType(gtype.getGtype());
        entity.setRecoveryAmount(successRetrieveCount);
        entity.setFileUrl(filePath);
        return this.goodsCouponRetrieveLogService.create(entity);
    }

    private List<Long> appendContenToOss(List<GoodsCouponEntity> list, boolean isLastPage) throws Exception {
        ArrayList<Long> rst = new ArrayList<Long>(1000);
        StringBuilder content = new StringBuilder();
        int i = 0;
        for (GoodsCouponEntity entity : list) {
            ++i;
            if (!StringUtils.isEmpty((Object)entity.getCode())) {
                content.append(entity.getCode());
            }
            if (!StringUtils.isEmpty((Object)entity.getPassword())) {
                content.append("\t");
                content.append(entity.getPassword());
            }
            if (!isLastPage || i != list.size()) {
                content.append("\n");
            }
            rst.add(entity.getId());
        }
        this.position = this.appendUploadUtil.upload(content.toString(), this.position);
        return rst;
    }

    @Override
    public GoodsBatchEntity findByStartDayAndDay(GoodsTypeEnum gtype, Long gid, Date startDay, Date endDay) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startDay = sdf.parse(sdf.format(startDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        try {
            endDay = sdf.parse(sdf.format(endDay));
        }
        catch (ParseException e) {
            log.error("date parse error", (Throwable)e);
        }
        return this.goodsBatchDao.selectByStartDayAndDay(gtype, gid, startDay, endDay);
    }
}

