/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.biz.dao.EverydayLimitDAO;
import cn.com.duiba.goods.center.biz.entity.EverydayLimitEntity;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class EverydayLimitServiceImpl
implements EverydayLimitService {
    private static Logger log = LoggerFactory.getLogger(EverydayLimitServiceImpl.class);
    @Autowired
    private EverydayLimitDAO everydayLimitDAO;

    @Override
    public boolean everydayLimitCheck(Long appItemId, Long itemId, int limit) {
        int ret;
        Date day = new Date();
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItemId, itemId, day);
        if (everyday == null) {
            everyday = new EverydayLimitEntity();
            everyday.setAppItemId(appItemId);
            everyday.setItemId(itemId);
            everyday.setSales(0);
            everyday.setDay(day);
            try {
                this.everydayLimitDAO.insert(everyday);
            }
            catch (DuplicateKeyException e) {
                log.error("everydayLimitCheck unique:appItemId:" + appItemId + " itemId:" + itemId + " day:" + new SimpleDateFormat("yyyy-MM-dd").format(day));
            }
        }
        return (ret = this.everydayLimitDAO.updateSales(everyday.getId(), limit)) >= 1;
    }

    @Override
    public void rollbackEverydayLimit(Long appItemId, Long itemId) {
        Date day = new Date();
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItemId, itemId, day);
        if (everyday == null) {
            return;
        }
        this.everydayLimitDAO.rollbackSales(everyday.getId());
    }

    @Override
    public Integer findEverydayLimitSales(Long appItemId, Long itemId) {
        Date day = new Date();
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItemId, itemId, day);
        if (everyday == null) {
            return 0;
        }
        return everyday.getSales();
    }
}

