/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.dao.EverydayLimitDAO;
import cn.com.duiba.goods.center.biz.dao.ItemLimitDao;
import cn.com.duiba.goods.center.biz.entity.EverydayLimitEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemLimitService;
import cn.com.duiba.goods.center.biz.util.DateUtil;
import cn.com.duiba.service.item.domain.dataobject.ItemLimitDO;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.transcoders.IntegerTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service(value="itemLimitService")
public class ItemLimitServiceImpl
implements ItemLimitService {
    private static Logger LOGGER = LoggerFactory.getLogger(ItemLimitServiceImpl.class);
    private static final String ITEM_NAMESPACE = "itemcache";
    private static final String APPITEM_NAMESPACE = "appitemcache";
    @Autowired
    private EverydayLimitDAO everydayLimitDAO;
    @Autowired
    private ItemLimitDao itemLimitDao;
    @Autowired
    private MemcachedClient memcachedClient;

    @Override
    public Boolean addQuantityLimitCounter(ItemKeyDto itemKey) {
        if (!this.isQuantityLimitItem(itemKey).booleanValue()) {
            return null;
        }
        if (!this.everydayLimitCheck(itemKey)) {
            return false;
        }
        try {
            boolean result;
            String key = this.getKey(itemKey);
            Integer limit = this.getLimit(itemKey);
            Integer state = this.setByCas(key, limit, 1);
            boolean bl = result = state == 0;
            if (!result && state == 2) {
                Integer countNum = this.countOrder(itemKey);
                OperationFuture future = this.memcachedClient.set(key, DateUtil.getToTomorrowSeconds(), (Object)countNum);
                if (((Boolean)future.get()).booleanValue()) {
                    state = this.setByCas(key, limit, 1);
                    result = state == 0;
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("\u9650\u91cf\u5e93\u5b58\u5546\u54c1\u52a01\u5f02\u5e38\uff1a", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean subQuantityLimitCounter(ItemKeyDto itemKey) throws Exception {
        boolean result;
        if (!this.isQuantityLimitItem(itemKey).booleanValue()) {
            return null;
        }
        this.rollbackEverydayLimitCheck(itemKey);
        String key = this.getKey(itemKey);
        Integer state = this.setByCas(key, 0, -1);
        boolean bl = result = state == 0;
        if (!result && state == 2) {
            result = this.deleteCounterByItemkey(itemKey);
        }
        return result;
    }

    private Boolean deleteCounterByItemkey(ItemKeyDto itemKey) throws Exception {
        String key = this.getKey(itemKey);
        boolean result = false;
        try {
            OperationFuture future = this.memcachedClient.delete(key);
            result = (Boolean)future.get();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u9650\u91cf\u5e93\u5b58\u6807\u8bb0\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return result;
    }

    private Integer countOrder(ItemKeyDto itemKey) throws Exception {
        return this.countItemLimit(itemKey);
    }

    private Integer countItemLimit(ItemKeyDto itemKey) throws Exception {
        String key = null;
        if (itemKey.isItemMode()) {
            key = ItemLimitDO.getItemKey((Long)itemKey.getItem().getId(), null);
        } else if (itemKey.isDuibaAppItemMode()) {
            key = ItemLimitDO.getItemKey((Long)itemKey.getItem().getId(), (Long)itemKey.getAppItem().getId());
        } else if (itemKey.isSelfAppItemMode()) {
            key = ItemLimitDO.getItemKey(null, (Long)itemKey.getAppItem().getId());
        }
        return this.itemLimitDao.countByItemKeyAndGmtCreate(key, DateUtil.getDayDate(new Date()));
    }

    private boolean everydayLimitCheck(ItemKeyDto itemKey) {
        Date day;
        Long itemId;
        Long appItemId = itemKey.getAppItem() == null ? 0L : itemKey.getAppItem().getId();
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItemId, itemId = Long.valueOf(itemKey.getItem() == null ? 0L : itemKey.getItem().getId()), day = new Date());
        if (everyday == null) {
            everyday = new EverydayLimitEntity();
            everyday.setAppItemId(appItemId);
            everyday.setItemId(itemId);
            everyday.setSales(0);
            everyday.setDay(day);
            try {
                this.everydayLimitDAO.insert(everyday);
            }
            catch (DuplicateKeyException e) {
                LOGGER.error("everydayLimitCheck unique:appItemId:" + appItemId + " itemId:" + itemId + " day:" + new SimpleDateFormat("yyyy-MM-dd").format(day));
            }
        }
        int limit = this.getLimit(itemKey);
        int ret = this.everydayLimitDAO.updateSales(everyday.getId(), limit);
        return ret >= 1;
    }

    private Boolean isQuantityLimitItem(ItemKeyDto itemKey) {
        if (itemKey.isItemMode()) {
            return itemKey.getItem().isOpTypeItem(1);
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                return true;
            }
            if (itemKey.getItem().isOpTypeItem(1)) {
                return true;
            }
        } else if (itemKey.isSelfAppItemMode()) {
            return itemKey.getAppItem().isOpTypeAppItem(1);
        }
        return false;
    }

    private Integer getLimit(ItemKeyDto itemKey) {
        Integer limit = null;
        if (itemKey.isItemMode()) {
            limit = itemKey.getItem().getLimitEverydayQuantity();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().isOpTypeItem(1)) {
                limit = itemKey.getItem().getLimitEverydayQuantity();
            } else if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                limit = itemKey.getAppItem().getLimitEverydayQuantity();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            limit = itemKey.getAppItem().getLimitEverydayQuantity();
        }
        return limit;
    }

    private String getKey(ItemKeyDto itemKey) throws Exception {
        String key = null;
        if (itemKey.isItemMode()) {
            key = ITEM_NAMESPACE + itemKey.getItem().getId();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().isOpTypeItem(1)) {
                key = ITEM_NAMESPACE + itemKey.getItem().getId();
            } else if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                key = APPITEM_NAMESPACE + itemKey.getAppItem().getId();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            key = APPITEM_NAMESPACE + itemKey.getAppItem().getId();
        }
        return key;
    }

    private void rollbackEverydayLimitCheck(ItemKeyDto itemKey) {
        Date day;
        Long itemId;
        Long appItemId = itemKey.getAppItem() == null ? 0L : itemKey.getAppItem().getId();
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItemId, itemId = Long.valueOf(itemKey.getItem() == null ? 0L : itemKey.getItem().getId()), day = new Date());
        if (everyday == null) {
            return;
        }
        this.everydayLimitDAO.rollbackSales(everyday.getId());
    }

    private Integer setByCas(String key, int limit, int type) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(key);
                if (last == null) {
                    loop = false;
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    if (++nextValue > limit) {
                        loop = false;
                        result = 3;
                        break;
                    }
                } else if (type < 0) {
                    if (--nextValue < limit) {
                        loop = false;
                        result = 3;
                        break;
                    }
                } else {
                    loop = false;
                    result = 4;
                    break;
                }
                CASResponse caseResponse = this.memcachedClient.cas(key, last.getCas(), DateUtil.getToTomorrowSeconds(), (Object)nextValue, (Transcoder)new IntegerTranscoder());
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
            LOGGER.error("\u66f4\u65b0\u7f13\u5b58\u5f02\u5e38:", (Throwable)e);
        }
        return result;
    }
}

