package cn.com.duiba.goods.center.biz.bo.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.bo.item.DuibaItemGoodsBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * Created by liuyao on 2016/11/21.
 */
@Service
public class DuibaItemGoodsBoImpl implements DuibaItemGoodsBo {

    @Autowired
    private ItemService itemService;
    @Autowired
    private GoodsBatchService goodsBatchService;

    @Override
    public List<ItemDto> findByIds(List<Long> ids) {
        List<ItemEntity> list = itemService.findAllByIds(ids);
        return transform(list);
    }

    private List<ItemDto> transform(List<ItemEntity> list){
        List<ItemDto> returnList = Lists.newArrayList();
        for(ItemEntity item:list){
            if (item.isOpTypeItem(ItemDto.OpTypeGoodsCoupon)) {
                Long stock = goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, item.getId());
                item.setRemaining(Integer.valueOf(stock.toString()));
            }
            ItemDto dto = new ItemDto();
            ObjectUtil.convert(item, dto);
            returnList.add(dto);
        }
        return returnList;
    }

    private ItemDto transform(ItemEntity item){
        if(item==null){
            return null;
        }
        if (item.isOpTypeItem(ItemDto.OpTypeGoodsCoupon)) {
            Long stock = goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, item.getId());
            item.setRemaining(Integer.valueOf(stock.toString()));
        }
        ItemDto dto = new ItemDto();
        ObjectUtil.convert(item, dto);
        return dto;
    }



}
