package cn.com.duiba.goods.center.biz.bo.item.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.apache.commons.collections.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;

import cn.com.duiba.goods.center.api.remoteservice.constant.CacheConstants;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.bo.item.ItemAutoRecommendBo;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemMaskService;
import cn.com.duiba.goods.center.biz.service.item.ItemAutoRecommendService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * Created by liuyao on 2016/11/17.
 */
@Service
public class ItemAutoRecommendBoImpl implements ItemAutoRecommendBo {
    @Autowired
    private ItemAutoRecommendService itemAutoRecommendService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemKeyBo itemKeyBo;
    @Autowired
    private AppItemMaskService appItemMaskService;

    @Override
    public List<ItemKeyDto> findHomeAutoRecommend(Long appId,Integer size) {

        List<Long> itemIds = getAutoRecommendItemIds(appId);

        if(itemIds.isEmpty()){
            return Collections.emptyList();
        }else{
            List<ItemDto> itemList = Lists.newArrayList();
            List<ItemEntity> items = itemService.findAllByIds(itemIds);
            for(ItemEntity item : items){
                if(!item.getEnable()){
                    continue;
                }
                ItemDto dto = new ItemDto();
                ObjectUtil.convert(item, dto);
                itemList.add(dto);
                if(itemList.size()>=size){
                    break;
                }
            }
            return itemKeyBo.transformItemList(itemList);
        }
    }

    private List<Long> getAutoRecommendItemIds(Long appId){
        List<Long> itemIdList = new ArrayList<Long>();
        // 自动推荐&非定向
        List<Long> allList = itemAutoRecommendService.findItemAutoRecommendNoSpecify(true, true);
        // 自动推荐&定向关系存在
        List<Long> spcefyList = itemAutoRecommendService.findItemSpecify(appId);
        // app 黑名单
        List<Long> appMaskingList = appItemMaskService.findItemAppMasking(appId);;
        // tag黑名单
        List<Long> tagsMaskingList = itemAutoRecommendService.findItemAppTagsMasking(appId);
        // 开发者库黑名单
        List<Long> inAppList = itemAutoRecommendService.findItemInApp(appId, false, false);

        itemIdList = ListUtils.sum(allList, spcefyList);
        itemIdList = ListUtils.subtract(itemIdList, appMaskingList);
        itemIdList = ListUtils.subtract(itemIdList, tagsMaskingList);
        itemIdList = ListUtils.subtract(itemIdList, inAppList);
        if(itemIdList.size()>20){
            itemIdList = itemIdList.subList(0,20);
        }

        return itemIdList;
    }

    private String getAutoRecommendItemIdsKey(Long appId){
        return CacheConstants.KeyAutoRecommendItemIdsByAppId + appId;
    }
}
