package cn.com.duiba.goods.center.biz.dao;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemExtraDto;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
public interface AppItemExtraDao {
    /**
     * 通过appItemId查询对应商品附加信息
     * @param appItemId 非空
     * @return
     */
    AppItemExtraDto findByAppItemId(Long appItemId);

    /**
     * 插入商品附加信息，appItemId不能为空
     * @param appItemExtra
     * @return
     */
    int insert(AppItemExtraDto appItemExtra);

    /**
     * 通过appItemId更新对应商品附加信息，appItemId 非空
     * @param appItemExtra
     * @return
     */
    int updateByAppItemId(AppItemExtraDto appItemExtra);

    /**
     * 通过appItemId删除对应商品附加信息
     * @param appItemId 非空
     * @return
     */
    int deleteByAppItemId(Long appItemId);
}
