/**
 * Project Name:goods-center-biz
 * File Name:GoodsCouponDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年5月23日下午12:13:32
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;

import java.util.List;

/**
 * ClassName:GoodsCouponDao <br/>
 * Date:     2016年5月23日 下午12:13:32 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsCouponDao {
    /**
     * 
     * insertBatchImport:批量导入普通优惠劵. <br/>
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param coupons 券列表
     * @return 影响行数
     * @since JDK 1.6
     */
    int insertBatchImport(GoodsTypeEnum gtype,long gid,long goodsBatchId,List<CouponFormat> coupons );
    /**
     * 
     * insertLinkCoupon:导入一条链接券. <br/>
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param goodsCouponId 券号
     * @param link 链接
     * @since JDK 1.6
     */
    void insertLinkCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,
                         String link);
    /**
     * 
     * insertRepeatCoupon:导入一条可重复券. <br/>
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param goodsCouponId 券号
     * @param code 卡号
     * @param password 密码
     * @since JDK 1.6
     */
    void insertRepeatCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,
                            String code,String password);
    
    /**
     * 更新链接券的链接内容
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param link 链接内容
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateLinkCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,
                         String link);
    /**
     * 更新重复券的卡号密码
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param code 卡号
     * @param password 密码
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateRepeatCoupon(GoodsTypeEnum gtype,long gid,long goodsBatchId,
                           String code,String password);
    
    /**
     * 查询券
     *
     * @author xuhengfei
     * @param goodsCouponId 券号
     * @return 券信息
     * @since JDK 1.6
     */
    GoodsCouponEntity selectByCouponId(Long goodsCouponId);
    /**
     * 查询未使用的券
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param limit 最大返回数
     * @return 结果集
     * @since JDK 1.6
     */
    List<GoodsCouponEntity> selectBatchNotUsed(GoodsTypeEnum gtype,long gid,long goodsBatchId,int limit);
    /**
     * 查询一张未使用的券
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @return 券信息
     * @since JDK 1.6
     */
    GoodsCouponEntity selectOneCouponNotUsed(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    /**
     * 根据批次获取一张券，主要是链接券，重复券获取信息
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @return 券信息
     * @since JDK 1.6
     */
    GoodsCouponEntity selectOneByGoodsBatchId(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    /**
     * 搜索券
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param code 卡号
     * @return 结果集
     * @since JDK 1.6
     */
    List<GoodsCouponEntity> selectSearchByCode(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code);
    /**
     * 查询批次下的券数量
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @return 数量
     * @since JDK 1.6
     */
//    int selectCountByBatch(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    /**
     * 查询批次下未使用的券数量
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @return 影响行数
     * @since JDK 1.6
     */
    int selectCountByBatchNotUsed(GoodsTypeEnum gtype,long gid,long goodsBatchId);
    /**
     * 批次下分页查询券
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param pageSize 分页大小
     * @param pageIndex 页码
     * @return
     * @since JDK 1.6
     */
    List<GoodsCouponEntity> selectPageByBatchId(GoodsTypeEnum gtype,long gid,long goodsBatchId,int pageSize,int pageIndex);
    /**
     * 标记锁定
     *
     * @author xuhengfei
     * @param gtype 商品类型
     * @param gid 商品id
     * @param goodsBatchId 批次id
     * @param goodsCouponId 券号
     * @param consumerId 用户id
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateCouponMarkLocked(GoodsTypeEnum gtype,long gid,long goodsBatchId,long goodsCouponId,long consumerId);
    /**
     * 标记优惠券为已使用
     *
     * @author xuhengfei
     * @param goodsCouponId 券号
     * @param orderId 订单id
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateCoupnoMarkUsed(long goodsCouponId,Long orderId);
    /**
     * 设置回滚优惠劵状态
     * @author xuhengfei
     * @param goodsCouponId 券号
     * @return 影响行数
     * @since JDK 1.6
     */
    int updateCouponMarkRollback(long goodsCouponId);


    int deleteGoodsCouponByIds(long gid ,List<Long> ids);

    public static class CouponFormat{
        private Long goodsCouponId;
        private String code;
        private String password;
        
        public Long getGoodsCouponId() {
            return goodsCouponId;
        }
        
        public void setGoodsCouponId(Long goodsCouponId) {
            this.goodsCouponId = goodsCouponId;
        }
        
        public String getCode() {
            return code;
        }
        
        public void setCode(String code) {
            this.code = code;
        }
        
        public String getPassword() {
            return password;
        }
        
        public void setPassword(String password) {
            this.password = password;
        }
        
    }
    
    int deleteBatchUnusedCoupons(Integer gtype, Long gid, Long id);
    
    public int deleteBatchUnusedCouponsByIds(Integer gtype, Long gid, Long batchId, List<Long> couponIds);
    
    public int deleteUnusedCoupon(Integer gtype, Long gid, Long couponId);
    
    /**
     * 查询批次下券码是否被使用过
     * @param gtype
     * @param gid
     * @param goodsBatchId
     * @return
     */
    Long selectByBatchExistUsed(Integer gtype,long gid,long goodsBatchId);
    
    List<GoodsCouponEntity> findUnusedCoupons(Integer gtype,long gid,long goodsBatchId, int limit);
    /**
     * 
     * 删除某个优惠券指定批次所有券码. <br/>
     *
     * @author ZFZ
     * @param gtype 商品类型
     * @param gid 商品id
     * @param batchId 批次id
     * @return 影响行数
     * @since JDK 1.6
     */
    int deleteGoodsCoupon(GoodsTypeEnum gtype, long gid, long batchId);

    List<GoodsCouponEntity> selectPageByBatchIdAndStatus(GoodsTypeEnum gtype, long gid,  long batchId,int status, int start, int limit);



}

