/**
 * Project Name:goods-center-biz
 * File Name:ItemDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年6月20日上午11:36:21
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;

import java.util.List;

/**
 * ClassName:ItemDao <br/>
 * Date:     2016年6月20日 上午11:36:21 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ItemDao {

    ItemEntity find(long id);

    /**
     * 获取活动链接券商品
     * @param ids
     * @return
     */
    List<ItemEntity> findLinkActivityCouponItemsByIds(List<Long> ids);

    /**
     * 根据 ids 获取 list
     * @param ids
     * @return
     */
    List<ItemEntity> findAllByIds(List<Long> ids);
    
    /**
     * 修改启用、禁用
     * @param itemId
     * @param enable
     * @return
     */
    Integer updateEnable(Long itemId, Boolean enable);

    /**
     * 获取积分商城首页显示的item,其中缺省一些字段
     * @param ids
     * @return
     */
    List<ItemDto> findHomeItems(List<Long> ids);
}

