package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemExtraDto;
import cn.com.duiba.goods.center.biz.dao.AppItemExtraDao;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import org.springframework.stereotype.Repository;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
@Repository("appItemExtraDao")
public class AppItemExtraDaoImpl extends BaseCreditsDao implements AppItemExtraDao {
    @Override
    public AppItemExtraDto findByAppItemId(Long appItemId) {
        return this.getSqlSession().selectOne(this.getStamentNameSpace("findByAppItemId"), appItemId);
    }

    @Override
    public int insert(AppItemExtraDto appItemExtra) {
        return this.getSqlSession().insert(this.getStamentNameSpace("insert"), appItemExtra);
    }

    @Override
    public int updateByAppItemId(AppItemExtraDto appItemExtra) {
        return this.getSqlSession().update(this.getStamentNameSpace("updateByAppItemId"),appItemExtra);
    }

    @Override
    public int deleteByAppItemId(Long appItemId) {
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteByAppItemId"),appItemId);
    }
}
