package cn.com.duiba.goods.center.biz.dao.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.EverydayLimitDAO;
import cn.com.duiba.goods.center.biz.entity.EverydayLimitEntity;

@Repository("everydayLimitDAO")
public class EverydayLimitDAOImpl extends BaseCreditsDao implements EverydayLimitDAO {

	@Override
	public void insert(EverydayLimitEntity everydayLimit) {
		getSqlSession().insert(getStamentNameSpace("insert"), everydayLimit);
	}

	@Override
	public EverydayLimitEntity find(Long appItemId, Long itemId, Date day) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("appItemId", appItemId);
		map.put("itemId", itemId);
		String date = new SimpleDateFormat("yyyy-MM-dd").format(day);
		map.put("day", date);
		return getSqlSession().selectOne(getStamentNameSpace("find"), map);
	}

	@Override
	public int updateSales(Long id, Integer limit) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("id", id);
		map.put("limit", limit);
		return getSqlSession().update(getStamentNameSpace("updateSales"), map);
	}
	
	@Override
	public int rollbackSales(Long id) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("id", id);
		return getSqlSession().update(getStamentNameSpace("rollbackSales"), map);
	}

}
