/**
 * Project Name:goods-center-biz
 * File Name:GoodsDirectionalConfigDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年6月28日上午11:19:57
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.GoodsDirectionalConfigDao;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;

/**
 * ClassName:GoodsDirectionalConfigDaoImpl <br/>
 * Date:     2016年6月28日 上午11:19:57 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("goodsDirectionalConfigDao")
public class GoodsDirectionalConfigDaoImpl extends BaseDao implements GoodsDirectionalConfigDao{

//    @Override
//    public List<GoodsDirectionalConfigEntity> select(GoodsDirectionalConfigEntity domain) {
//        return getSqlSession().selectList(getStamentNameSpace("select"),domain);
//    }

    @Override
    public List<GoodsDirectionalConfigEntity> selectByGoods(int gtype, long goodsId) {
        Map<String, Object> params=getBlankParams();
        params.put("goodsType", gtype);
        params.put("goodsId", goodsId);
        return getSqlSession().selectList(getStamentNameSpace("selectByGoods"),params);
    }
    
    @Override
    public GoodsDirectionalConfigEntity selectByGoodsAndApp(int gtype, long goodsId, long appId) {
        Map<String, Object> params=getBlankParams();
        params.put("goodsType", gtype);
        params.put("goodsId", goodsId);
        params.put("appId", appId);
        return getSqlSession().selectOne(getStamentNameSpace("selectByGoodsAndApp"),params);
    }
    
    @Override
    public int insert(GoodsDirectionalConfigEntity domain) {
        return getSqlSession().insert(getStamentNameSpace("insert"),domain);
    }

    @Override
    public int update(long id,Integer dayLimit, Integer minPrice) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("dayLimit", dayLimit);
        params.put("minPrice", minPrice);
        return getSqlSession().update(getStamentNameSpace("update"),params);
    }
    @Override
    public int updateMore(long id,Long stockId,Integer dayLimit, Integer minPrice) {
        Map<String, Object> params=getBlankParams();
        params.put("id", id);
        params.put("dayLimit", dayLimit);
        params.put("minPrice", minPrice);
        params.put("stockId", stockId);
        return getSqlSession().update(getStamentNameSpace("updateMore"),params);
    }

    @Override
    public int delete(Long id) {
        return getSqlSession().delete(getStamentNameSpace("delete"),id);
    }

    @Override
    public GoodsDirectionalConfigEntity selectById(Long id) {
        return getSqlSession().selectOne(getStamentNameSpace("selectById"), id);
    }

	@Override
	public List<GoodsDirectionalConfigEntity> selectByGoodsAll(GoodsTypeEnum gtype, List<Long> goodsIds) {
        if(goodsIds.isEmpty()){
            return Collections.emptyList();
        }
		Map<String, Object> params=getBlankParams();
		params.put("goodsType", gtype.getGtype());
        params.put("goodsIds", goodsIds);
		return getSqlSession().selectList(getStamentNameSpace("selectByGoodsAll"),params);
	}





}

