/**
 * Project Name:goods-center-biz
 * File Name:PCGCategoryGoodsDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月26日下午5:47:33
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.PCGCategoryGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryGoodsEntity;

/**
 * ClassName:PCGCategoryGoodsDaoImpl <br/>
 * Date:     2016年5月26日 下午5:47:33 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("pCGCategoryGoodsDao")
public class PCGCategoryGoodsDaoImpl extends BaseDao implements PCGCategoryGoodsDao{

    @Override
    public int selectMaxPayloadByCategory(long categoryId) {
        Map<String, Object> params=getBlankParams();
        params.put("categoryId", categoryId);
        Integer max= getSqlSession().selectOne(getStamentNameSpace("selectMaxPayloadByCategory"),params);
        if(max==null){
            return 1;
        }
        return max;
    };
    @Override
    public int insertGoods2Category(long pcgId, long categoryId,int payload) {
        Map<String, Object>  params=getBlankParams();
        params.put("pcgId", pcgId);
        params.put("categoryId", categoryId);
        params.put("payload", payload);
        return getSqlSession().insert(getStamentNameSpace("insertGoods2Category"), params);
    }

    @Override
    public int deleteGoods2Category(long pcgId, long categoryId) {
        Map<String, Object>  params=getBlankParams();
        params.put("pcgId", pcgId);
        params.put("categoryId", categoryId);
        return getSqlSession().delete(getStamentNameSpace("deleteGoods2Category"), params);
    }

    @Override
    public int deleteCategoryRelation(long categoryId) {
        Map<String, Object>  params=getBlankParams();
        params.put("categoryId", categoryId);
        return getSqlSession().delete(getStamentNameSpace("deleteCategoryRelation"), params);
    }

    @Override
    public int deleteGoodsRelation(long pcgId) {
        Map<String, Object>  params=getBlankParams();
        params.put("pcgId", pcgId);
        return getSqlSession().delete(getStamentNameSpace("deleteGoodsRelation"), params);
    }

    @Override
    public List<PCGCategoryGoodsEntity> selectByCategory(long categoryId) {
        Map<String, Object>  params=getBlankParams();
        params.put("categoryId", categoryId);
        return getSqlSession().selectList(getStamentNameSpace("selectByCategory"),params);
    }

    @Override
    public List<PCGCategoryGoodsEntity> selectByGoods(long pcgId) {
        Map<String, Object>  params=getBlankParams();
        params.put("pcgId", pcgId);
        return getSqlSession().selectList(getStamentNameSpace("selectByGoods"),params);
    }

    @Override
    public int updatePayload(long categoryId, long pcgId, int payload) {
        Map<String, Object> params=getBlankParams();
        params.put("categoryId", categoryId);
        params.put("pcgId", pcgId);
        params.put("payload", payload);
        return getSqlSession().update(getStamentNameSpace("updatePayload"), params);
    }
	@Override
	public List<PCGCategoryGoodsEntity> selectAllGoodsByCateIds(List<Long> catIds) {
		Map<String, Object>  params=getBlankParams();
        params.put("catIds", catIds);
        return getSqlSession().selectList(getStamentNameSpace("selectAllGoodsByCateIds"),params);
	}
    
    
}

