/**
 * Project Name:goods-center-biz
 * File Name:GoodLimitRecordServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.impl
 * Date:2016年6月28日上午10:48:37
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.dao.GoodsLimitRecordDao;
import cn.com.duiba.goods.center.biz.entity.GoodsLimitRecordEntity;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;

/**
 * ClassName:GoodLimitRecordServiceImpl <br/>
 * Date:     2016年6月28日 上午10:48:37 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("goodLimitRecordService")
public class GoodsLimitRecordServiceImpl implements GoodsLimitRecordService{
    @Autowired
    private GoodsLimitRecordDao goodsLimitRecordDao;
    @Override
    public int findCount(int gtype, long gid, long consumerId) {
        GoodsLimitRecordEntity e= goodsLimitRecordDao.selectByCondition(gtype, gid, consumerId);
        if(e==null || e.getCount()==null){
            return 0;
        }
        return e.getCount();
    }

    @Override
    public void addRecord(int gtype, long gid, long consumerId) {
        GoodsLimitRecordEntity e= goodsLimitRecordDao.selectByCondition(gtype, gid, consumerId);
        if(e==null){
            goodsLimitRecordDao.insertRecord(gtype, gid, consumerId);
        }else{
            goodsLimitRecordDao.updateIncreament(gtype, gid, consumerId);
        }
    }

    @Override
    public void rollbackRecord(int gtype, long gid, long consumerId) {
        goodsLimitRecordDao.updateRollback(gtype, gid, consumerId);
    }

	@Override
	public List<GoodsLimitRecordEntity> findCounts(int gtype, List<Long> gids,
			long consumerId) {
		return goodsLimitRecordDao.selectCounts(gtype, gids, consumerId);
	}

}

