package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemExtraDto;
import cn.com.duiba.goods.center.biz.dao.AppItemExtraDao;
import cn.com.duiba.goods.center.biz.service.item.AppItemExtraService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
@Service("appItemExtraService")
public class AppItemExtraServiceImpl implements AppItemExtraService{
    @Autowired
    private AppItemExtraDao appItemExtraDao;

    @Override
    public AppItemExtraDto findByAppItemId(Long appItemId) {
        return appItemExtraDao.findByAppItemId(appItemId);
    }

    @Override
    public int insert(AppItemExtraDto appItemExtra) {
        return appItemExtraDao.insert(appItemExtra);
    }

    @Override
    public int updateByAppItemId(AppItemExtraDto appItemExtra) {
        return appItemExtraDao.updateByAppItemId(appItemExtra);
    }

    @Override
    public int deleteByAppItemId(Long appItemId) {
        return appItemExtraDao.deleteByAppItemId(appItemId);
    }

    @Override
    public int insertOrUpdateByAppItemId(AppItemExtraDto appItemExtra) {
        AppItemExtraDto dto = appItemExtraDao.findByAppItemId(appItemExtra.getAppItemId());
        if(dto==null){
            return appItemExtraDao.insert(appItemExtra);
        }else{
            return appItemExtraDao.updateByAppItemId(appItemExtra);
        }
    }
}
