package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.dao.AppItemDao;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by liuyao on 2016/11/16.
 */
@Service
public class AppItemServiceImpl implements AppItemService {
    @Autowired
    private AppItemDao appItemDao;

    @Override
    public AppItemDto find(Long appItemId) {
        return appItemDao.find(appItemId);
    }

    @Override
    public List<AppItemDto> findByIds(List<Long> ids) {
        return appItemDao.findByIds(ids);
    }

    @Override
    public AppItemDto findByAppIdAndItemId(Long appId, Long itemId) {
        return appItemDao.findByAppIdAndItemId(appId, itemId);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        return appItemDao.findAppIdsByInActivityId(activityId, type);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        return appItemDao.findAppIdsByActivityId(relationId);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        return appItemDao.findAppIdByItemIds(itemIds);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        return appItemDao.findAppIdsByIds(ids);
    }
}
