/**
 * Project Name:goods-center-biz
 * File Name:SimpleItemServiceImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.service.item.impl
 * Date:2016年6月20日上午11:35:36
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service.item.impl;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.biz.dao.ItemDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.SimpleItemService;

/**
 * ClassName:SimpleItemServiceImpl <br/>
 * Date:     2016年6月20日 上午11:35:36 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("simpleItemService")
public class SimpleItemServiceImpl implements SimpleItemService{
    @Autowired
    private ItemDao itemDao;
    @Override
    public ItemEntity find(long itemId) {
        ItemEntity item=itemDao.find(itemId);
        return item;
    }

	@Override
	public Boolean updateEnable(long itemId, boolean enable) {
		int ret = itemDao.updateEnable(itemId, enable);
		if (ret > 0) {
			return true;
		}
		return false;
	}

}

