/**
 * Project Name:goods-center-biz
 * File Name:PCGUtilBOImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.bo.pcg.impl
 * Date:2016年6月28日下午2:20:49
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.bo.pcg.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.constant.PlatformCouponGoodsConstant;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.SwitchUtils;
import cn.com.duiba.goods.center.biz.bo.pcg.PCGUtilBO;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsDirectionalConfigService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.PCGFilterConfigService;
import cn.com.duiba.goods.center.biz.service.PlatformCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsDirectionalConfigServiceImpl.DayLimitConfig;
import cn.com.duiba.goods.center.biz.service.stock.PcgDirectionalSalesVolumeService;
import cn.com.duiba.goods.center.biz.util.PcgCreditsCalculteTool;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteSellerService;
import cn.com.duiba.stock.service.api.constant.SaleLimitTypes;
import cn.com.duiba.stock.service.api.remoteservice.RemoteSaleLimitService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:PCGUtilBOImpl <br/>
 * Date:     2016年6月28日 下午2:20:49 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service("pCGUtilBO")
public class PCGUtilBOImpl implements PCGUtilBO{
    private static Logger log=LoggerFactory.getLogger(PCGUtilBOImpl.class);
    @Autowired
    private PlatformCouponGoodsService platformCouponGoodsService;
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    private PCGFilterConfigService pcgFilterConfigService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private GoodsDirectionalConfigService goodsDirectionalConfigService;
    @Autowired
    private RemoteSaleLimitService remoteSaleLimitService;
    @Autowired
    private PcgDirectionalSalesVolumeService pcgDirectionalSalesVolumeService;
    @Override
    public boolean canTakePlatformCouponGoods(long pcgId, long appId, long consumerId) throws Exception {
        PlatformCouponGoodsEntity pcg=platformCouponGoodsService.find(pcgId);
        if(pcg==null){
            log.error("canTakePlatformCouponGoods pcgId="+pcgId+", but query result is null");
            throw new Exception("商品不存在");
        }
        if(pcg.getDeleted()){
            log.error("canTakePlatformCouponGoods pcgId="+pcgId+", but query result is deleted");
            throw new Exception("商品已删除");
        }
        //校验商品状态
        if(pcg.getPcgStatus()==PlatformCouponGoodsConstant.PcgStatusOff){
            throw new Exception("商品已下架");
        }
        //校验是否被屏蔽
        if(isInBlack(pcg,appId)){
            throw new Exception("商品无法兑换");
        }
        
        
        //查询是否有库存(总库存，预分配库存，每日限量库存)
        if(!checkStockEnough(pcg, appId, consumerId)){
            throw new Exception("商品库存不足");
        }
        return true;
    }
    
    @Override
    public long getStockInApp(long pcgId, long appId) {
        //总库存判断
        Long stock=goodsBatchService.getSumBatchStock(GoodsTypeEnum.PLATFORM, pcgId);
        if(stock==null || stock<=0){
            return 0L;
        }
        
        PlatformCouponGoodsEntity pcg=platformCouponGoodsService.find(pcgId);
        //定向App预分配库存判断
        if(SwitchUtils.enable(pcg.getSwitches().intValue(), PlatformCouponGoodsConstant.PcgDirectionalSwitches)){
            GoodsDirectionalConfigEntity config=goodsDirectionalConfigService.findByGoodsAndAppIncludeShared(GoodsTypeEnum.PLATFORM, pcgId, appId);
            if(config==null){
                return 0L;
            }else{
                if(config.getStockId()==null){
                    //如果为null，表示0库存
                    return 0L;
                }
                DubboResult<Long> stockRet=remoteStockService.find(config.getStockId());
                if(!stockRet.isSuccess() || stockRet.getResult()<=0){
                    return 0L;
                }
                //取较小值
                if(stock>stockRet.getResult()){
                    stock=stockRet.getResult();
                }
                
            }
        }
        
        //定向App每日限量库存判断
        DayLimitConfig config=goodsDirectionalConfigService.getDayLimit(GoodsTypeEnum.PLATFORM, pcgId, appId);
        
        if(config!=null){
            if(config.getDayLimit()<=0){
                return 0L;
            }
            
            Long sales=pcgDirectionalSalesVolumeService.findSaleCountToday(pcgId, config.getConfig().getId());
            if(sales>=config.getDayLimit().intValue()){
                return 0L;
            }
            //取较小值
            long remaining=config.getDayLimit()-sales;
            if(stock>remaining){
                stock=remaining;
            }
        }
        return stock;
    }
    
    @Override
    public boolean checkStockEnough(long pcgId, long appId, long consumerId){
        PlatformCouponGoodsEntity pcg=platformCouponGoodsService.find(pcgId);
        return checkStockEnough(pcg, appId, consumerId);
    }
    
    public boolean checkStockEnough(PlatformCouponGoodsEntity pcg, long appId, long consumerId){
        long pcgId=pcg.getPcgId();
        long stock=getStockInApp(pcg.getPcgId(),appId);
        if(stock<=0){
            return false;
        }

        
        // 用户兑换限制校验
        if(pcg.getLimitPerConsumer()!=null){
            int limit=pcg.getLimitPerConsumer();
            int count=goodsLimitRecordService.findCount(GoodsTypeEnum.PLATFORM.getGtype(), pcgId, consumerId);
            if(count>=limit){
                return false;
//                throw new Exception("超出用户兑换限制");
            }
        }
        return true;
    }
    
    
    @Override
    public boolean isInBlack(PlatformCouponGoodsEntity pcg,long appId) {
        List<PlatformCouponGoodsEntity> goods=pcgFilterConfigService.findGoodsFilterList(appId);
        Set<Long> blackGoodsIds=new HashSet<>();
        for(PlatformCouponGoodsEntity e:goods){
            blackGoodsIds.add(e.getPcgId());
        }
        if(blackGoodsIds.contains(pcg.getPcgId())){
            return true;
        }
        
        List<PCGFilterConfigDto> belongs= pcgFilterConfigService.findCounponBelong(pcg.getPcgId());
        
        if(belongs.isEmpty()){
            return false;
        }
        
        List<PCGCategoryEntity> cates=pcgFilterConfigService.findCategoryFilterList(appId);
        List<PCGSellerEntity> sellers=pcgFilterConfigService.findSellerFilterList(appId);
        
        Set<Long> catSet=new HashSet<>();
        for(PCGCategoryEntity c:cates){
            catSet.add(c.getId());
        }

        Set<Long> sellerSet=new HashSet<>();
        for(PCGSellerEntity e:sellers){
            sellerSet.add(e.getId());
        }
        
        for(PCGFilterConfigDto f:belongs){
            if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigCategoryType){
                if(catSet.contains(f.getTargetId())){
                    //商品所属类目在黑名单中
                    return true;
                }
            }else if(f.getType()==PlatformCouponGoodsConstant.PcgFilterConfigSellerType){
                if(sellerSet.contains(f.getTargetId())){
                    //商品在所属品牌的黑名单中
                    return true;
                }
            }
        }
            
        
        return false;
    }
    
    
    @Override
    public Long calcultePCGCredits(long pcgId, long appId, long consumerId) {
        PlatformCouponGoodsEntity pcg=platformCouponGoodsService.find(pcgId);
        if(SwitchUtils.enable(pcg.getSwitches().intValue(), PlatformCouponGoodsConstant.PcgDirectionalSwitches)){
          //定向App预分配积分计算
            GoodsDirectionalConfigEntity e=goodsDirectionalConfigService.findByGoodsAndApp(GoodsTypeEnum.PLATFORM, pcgId, appId);
            if(e==null){
                e=goodsDirectionalConfigService.findSharedByGoods(GoodsTypeEnum.PLATFORM, pcgId);
                if(e!=null && e.getMinPrice()!=null){
                    return PcgCreditsCalculteTool.getCredits(e.getMinPrice(), remoteAppService.find(appId).getCreditsRate());
                }
            }else{
                if(e.getMinPrice()!=null){
                    return PcgCreditsCalculteTool.getCredits(e.getMinPrice(), remoteAppService.find(appId).getCreditsRate());
                }
            }
        }
        
        //正常积分汇率计算
        Long credits=PcgCreditsCalculteTool.getCredits(pcg.getMinPrice(), remoteAppService.find(appId).getCreditsRate());
        return credits;
    }

}

