package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

public interface AppItemDao {
	
	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public AppItemEntity find(Long id);

	/**
	 * 根据ID集合查询应用商品信息
	 * 
	 * @param ids
	 * @return
	 */
	public List<AppItemEntity> findByIds(List<Long> ids);
	
	/**
	 * 根据itemID查询
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId);

	/**
	 * 创建商品
	 * 
	 * @param AppItemEntity
	 * @return
	 */
	public void insert(AppItemEntity appItemEntity);

	/**
	 * 修改商品
	 * 
	 * @param appItem
	 * @return
	 */
	public Integer update(AppItemEntity appItemEntity);

	/**
	 * 删除商品
	 *
	 * @param appId
	 * @param appItemId
	 */
	public Integer delete(Long appId, Long appItemId);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public Integer deleteByIds(Long appId, List<Long> appItemId);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Integer updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public Integer updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 减一个库存
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer decrStock(Long appItemId);

	/**
	 * 加一个库存
	 * 
	 * @param appItemId
	 * @param bizId
	 * @return
	 */
	public Integer incrStock(Long appItemId);

	/**
	 * 编辑商品，增加库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Integer appendStock(Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Integer deductStock(Long appItemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param appItemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate);
	
	/**
	 * 修改EXPIED为null
	 * 
	 * @param itemId
	 * @return
	 */
	public Integer updateExpiedAppItem(Long itemId);

	/**
	 * 修改EXPIED为null
	 * 
	 * @param appItemId
	 * @return
	 */
	public Integer updateExpiedAppItemById(Long appItemId);


}
