package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.biz.entity.CouponBatchEntity;

/**
 * 老的优惠券批次DAO
 */
public interface CouponBatchDao {

	/**
	 * 添加一条批次
	 */
	public void insert(CouponBatchEntity CouponBatchEntity);

	/**
	 * 修改批次信息
	 */
	public int update(CouponBatchEntity CouponBatchEntity);

	/**
	 * 查询批次
	 */
	public CouponBatchEntity find(Long id);

	/**
	 * 悲观锁查询批次
	 */
	public CouponBatchEntity findForUpdate(Long id);

	/**
	 * 查询商品下一个可用批次
	 */
	public CouponBatchEntity findItemNextBatch(Long itemId);

	/**
	 * 查询商品下一个可用批次
	 */
	public CouponBatchEntity findAppItemNextBatch(Long appItemId);

	/**
	 * 查询商品最大过期时间批次
	 */
	public CouponBatchEntity findItemMaxValidEndDateBatch(Long itemId);

	/**
	 * 查询最大的过期时间
	 */
	public CouponBatchEntity findAppItemMaxValidEndDateBatch(Long appItemId);

	/**
	 * 修改批次状态和库存
	 */
	public int updateActiveAndRemaining(Long id, Integer active, Integer remaining);

	/**
	 * 修改批次的状态
	 */
	public int updateActive(Long id, Integer active);

	/**
	 * 根据批次时间查询批次
	 */
	public CouponBatchEntity findItemBatchByValidStartDateAndValidEndDate(Long itemId, Date validStartDate, Date validEndDate);

	/**
	 * 根据批次时间查询批次
	 */
	public CouponBatchEntity findAppItemBatchByValidStartDateAndValidEndDate(Long appItemId, Date validStartDate, Date validEndDate);

	/**
	 * 根据itemId获取最后一个批次
	 */
	public CouponBatchEntity findLastBatchByItemId(Long itemId);

	/**
	 * 查询兑换项-优惠券的所有批次
	 * 
	 * @param appItemId
	 * @param itemId
	 * @param valid
	 *            NULL-所有批次 不包含删除的批次 "valid"--正在使用和新建的批次
	 * @return
	 */
	public List<CouponBatchEntity> findAllBatch(Long appItemId, Long itemId, String valid);

	/**
	 * 刷新所有新建但过期了的批次
	 */
	public void updateAllNewOverDueBatch();

	/**
	 * 查询新的过期批次ID
	 */
	public List<Long> selectIdsOfNewOverDueBatch();

	/**
	 * 将批次设为NULL
	 */
	public void setItemBatchEmpty(Long itemId);

	/**
	 * 设置批次ID
	 */
	public int setItemBatchId(Long itemId, Long batchId);

	/**
	 * 设置批次ID
	 */
	public int setAppItemBatchId(Long appItemId, Long batchId);

	/**
	 * 将批次设为NULL
	 */
	public void setAppItemBatchEmpty(Long appItemId);

	/**
	 * 根据优惠券ID和结束时间查找批次
	 */
	public CouponBatchEntity findBatchByValidEndDate(Long appItemId, Long itemId, Date validEndDate);

	/**
	 * 根据商品开始时间和结束时间查询批次信息
	 */
	public CouponBatchEntity findBatchByValidStartDateAndValidEndDate(Long appItemId, Long itemId, Date validStartDate, Date validEndDate);

	/**
	 * 查询最大结束时间
	 */
	public Date getMaxValidEndDate(Long appItemId, Long itemId);

	/**
	 * 查询最近有效的结束时间
	 */
	public Date getMinValidEndDate(Long appItemId, Long itemId);

	/**
	 * 计算优惠券有效库存
	 */
	public Integer countAllRemaining(Long appItemId, Long itemId);

	/**
	 * 删除批次信息
	 */
	public Integer deleteBatchRecord(Long batchId);

	/**
	 * 返还批次库存+1
	 */
	public Integer turnbackCouponBatchRemaining(Long batchId);

	/**
	 * 扣除批次库存-1
	 */
	public Integer reduceCouponBatchRemaining(Long batchId);

	/**
	 * 计算批次剩余库存
	 */
	public Integer countBatchRemaining(Long batchId);

	/**
	 * 根据批次Id列表查询各批次
	 */
	public List<CouponBatchEntity> findBatchInIds(List<Long> ids);

	/**
	 * 只检索了id,开始时间和结束时间
	 */
	public List<CouponBatchEntity> findAllBatchSimple(Long appItemId);

	/**
	 * 查询批次数量
	 */
	public Long findBatchNum(Long appItemId);

	/**
	 * 异步更新批次库存
	 */
	public Integer asyncUpdateBatchStock(Long batchId, int decrease);

}
