package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.biz.entity.ItemAppSpecifyEntity;


public interface ItemAppSpecifyDao {

	/**
	 * 根据兑换项ID和appId查找
	 */
	public List<ItemAppSpecifyEntity> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId);
	
	/**
	 * 查找兑换项的定向关系表
	 * @param itemId
	 * @return
	 */
	public List<ItemAppSpecifyEntity> findAllByItemId(Long itemId);
	
	/**
	 * 删除定向关系
	 * @param id
	 */
	public void delete(Long id);
	/**
	 * 扣预分配库存
	 * @param itemId
	 * @param appId
	 * @return
	 */
	public int reduceRemaining(Long itemId, Long appId);
	/**
	 * 加预分配库存
	 * @param itemId
	 * @param appId
	 * @return
	 */
	public int increaseRemaining(Long itemId, Long appId);
	
	/**
	 * 根据兑换项ID和appId查找定向库存，没有则为NULL
	 * @param itemId
	 * @param appId
	 * @return
	 */
	public Long findSpecifyRemaining(Long itemId, Long appId);

	/**
	 * 找出不是该APP的定向商品
	 * @param appId
	 * @return
	 */
	public List<Long> findNOSpecify4App(Long appId);
	
	/**
	 * 找出不是该APP的（后台新加的开发者未浏览过的）定向商品
	 * @param appId
	 * @return
	 */
	public List<Long> findNOSpecify4AppNew(Long appId, Date newItemTime);
	
	/**
	 * 根据itemId和appId
	 * @param itemId
	 * @param appId
	 * @return
	 */
	public ItemAppSpecifyEntity findByItemIdAndAppId(Long itemId, Long appId);
	
	/**
	 * 根据itemId和appId
	 * @param itemId
	 * @param appId
	 * @return
	 */
	public ItemAppSpecifyEntity findByItemIdAndAppIdLock(Long itemId, Long appId);
	
	/**
	 * 新增定向信息
	 * @param ItemAppSpecifyEntity
	 */
	public void insert(ItemAppSpecifyEntity ItemAppSpecifyEntity);
	
	/**
	 * 查询定向信息
	 * @param id
	 * @return
	 */
	public ItemAppSpecifyEntity find(Long id);

	/**
	 * 修改定向库存
	 * @param id
	 * @param remaining
	 */
	public void updateRemaining(Long id, Integer remaining);
	
	/**
	 * 查询APP的定向商品
	 * @param appId
	 * @return
	 */
	public List<Long> findItemSpecify(Long appId);

}
