/**
 * Project Name:goods-center-biz
 * File Name:ItemDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年6月20日上午11:36:21
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.item;

import java.util.Date;
import java.util.List;

import cn.com.duiba.goods.center.biz.entity.ItemEntity;

/**
 * ClassName:ItemDao <br/>
 * Date:     2016年6月20日 上午11:36:21 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ItemDao {

	/**
	 * 通过ID查询
	 * @param id
	 * @return
	 */
    public ItemEntity find(long id);

    /**
     * 获取活动链接券商品
     * @param ids
     * @return
     */
    public List<ItemEntity> findLinkActivityCouponItemsByIds(List<Long> ids);

    /**
     * 根据 ids 获取 list
     * @param ids
     * @return
     */
    public List<ItemEntity> findAllByIds(List<Long> ids);
    
	/**
	 * 创建商品
	 * 
	 * @param appItemEntity
	 * @return
	 */
	public void insert(ItemEntity ItemEntity);

	/**
	 * 修改商品
	 * 
	 * @param appItem
	 * @return
	 */
	public Integer update(ItemEntity ItemEntity);

	/**
	 * 删除商品
	 * 
	 * @param itemId
	 */
	public Integer delete(Long itemId);

	/**
	 * 修改启用禁用
	 * 
	 * @param itemId
	 * @param enable
	 * @return
	 */
	public Integer updateEnable(Long itemId, Boolean enable);

	/**
	 * 减少一个库存
	 * @param itemId
	 * @return
	 */
	public Integer decrStock(Long itemId);
	
	/**
	 * 增加一个库存
	 * @param itemId
	 * @param bizId
	 * @return
	 */
	public Integer incrStock(Long itemId);
	
	/**
	 * 编辑商品，增加库存
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Integer appendStock(Long itemId, Long number);
	
	/**
	 * 编辑商品，减少库存
	 * 
	 * @param itemId
	 * @param number
	 * @return
	 */
	public Integer deductStock(Long itemId, Long number);
	
	/**
	 * 修改库存和过期时间
	 * @param appItemId
	 * @param totalStock
	 * @param validEndDate
	 * @return
	 */
	public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate);

}

