package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;

@Repository("appItemDao")
public class AppItemDaoImpl extends BaseCreditsDao implements AppItemDao {
	
	private String appIdKey = "appId";

	@Override
	public AppItemEntity find(Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		return getSqlSession().selectOne(getStamentNameSpace("find"), queryMap);
	}

	@Override
	public List<AppItemEntity> findByIds(List<Long> ids) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("ids", ids);
		return getSqlSession().selectList(getStamentNameSpace("findByIds"), queryMap);
	}

	@Override
	public void insert(AppItemEntity appItemEntity) {
		getSqlSession().insert(getStamentNameSpace("insert"), appItemEntity);
	}

	@Override
	public Integer update(AppItemEntity appItemEntity) {
		return getSqlSession().update(getStamentNameSpace("update"), appItemEntity);
	}

	@Override
	public Integer delete(Long appId, Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("delete"), queryMap);
	}

	@Override
	public Integer deleteByIds(Long appId, List<Long> ids) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("ids", ids);
		return getSqlSession().update(getStamentNameSpace("deleteByIds"), queryMap);
	}

	@Override
	public Integer updateStatus(Long appId, Long id, String status) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("id", id);
		queryMap.put("status", status);
		return getSqlSession().update(getStamentNameSpace("updateStatus"), queryMap);
	}

	@Override
	public Integer updateStatusByIds(Long appId, List<Long> ids, String status) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("ids", ids);
		queryMap.put("status", status);
		return getSqlSession().update(getStamentNameSpace("updateStatusByIds"), queryMap);
	}
	
	@Override
	public Integer decrStock(Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("decrStock"), queryMap);
	}

	@Override
	public Integer incrStock(Long id) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("incrStock"), queryMap);
	}

	@Override
	public Integer appendStock(Long id, Long number) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		queryMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("incrStock"), queryMap);
	}

	@Override
	public Integer deductStock(Long id, Long number) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", id);
		queryMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("deductStock"), queryMap);
	}

	@Override
	public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put(appIdKey, appId);
		queryMap.put("itemId", itemId);
		return getSqlSession().selectOne(getStamentNameSpace("findByAppIdAndItemId"), queryMap);
	}

	@Override
	public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("id", appItemId);
		queryMap.put("totalStock", totalStock);
		queryMap.put("validEndDate", validEndDate);
		return getSqlSession().update(getStamentNameSpace("updateRemainingAndvalidEndDate"), queryMap);
	}
	
	@Override
	public Integer updateExpiedAppItem(Long itemId){
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("itemId", itemId);
		return getSqlSession().update(getStamentNameSpace("updateExpiedAppItem"), queryMap);
	}
	
	@Override
	public Integer updateExpiedAppItemById(Long appItemId){
		Map<String, Object> queryMap = new HashMap<>();
		queryMap.put("appItemId", appItemId);
		return getSqlSession().update(getStamentNameSpace("updateExpiedAppItemById"), queryMap);
	}


}
