package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemMaskDao;
import cn.com.duiba.goods.center.biz.entity.AppItemMaskingEntity;

@Repository
public class AppItemMaskDaoImpl extends BaseCreditsDao implements AppItemMaskDao {

	@Override
	public AppItemMaskingEntity findByItem(Long itemId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("itemId", itemId);
		return getSqlSession().selectOne("findByItem", map);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("id", id);
		getSqlSession().delete("delete", map);
	}

	@Override
	public List<AppItemMaskingEntity> findAllByApp(Long appId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("appId", appId);
		return getSqlSession().selectList("findAllByApp", map);
	}

	@Override
	public AppItemMaskingEntity findByAppIdAndItemId(Long appId, Long itemId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("appId", appId);
		map.put("itemId", itemId);
		return getSqlSession().selectOne("findByAppIdAndItemId", map);
	}

	@Override
	public void insert(AppItemMaskingEntity AppItemMaskingEntity) {
		getSqlSession().insert("insert", AppItemMaskingEntity);
	}

	@Override
	public AppItemMaskingEntity find(Long id) {
		return getSqlSession().selectOne("find", id);
	}

	@Override
	public List<Long> findItemAppMasking(Long appId) {
		Map<String, Object> queryMap = new HashMap<String, Object>();
		queryMap.put("appId", appId);
		return getSqlSession().selectList("findItemAppMasking", queryMap);
	}

}
