package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.entity.ItemAppSpecifyEntity;

@Repository
public class ItemAppSpecifyDaoImpl extends BaseCreditsDao implements ItemAppSpecifyDao {

	@Override
	public List<ItemAppSpecifyEntity> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemIds", itemIds);
		paramMap.put("appId", appId);
		return getSqlSession().selectList("findSpecifyByItemIdsAndAppId", paramMap);
	}

	@Override
	public List<ItemAppSpecifyEntity> findAllByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		return getSqlSession().selectList("findAllByItemId", paramMap);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		getSqlSession().delete("delete", paramMap);
	}

	@Override
	public int reduceRemaining(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		paramMap.put("appId", appId);
		return getSqlSession().update("reduceRemaining", paramMap);
	}

	@Override
	public int increaseRemaining(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		paramMap.put("appId", appId);
		return getSqlSession().update("increaseRemaining", paramMap);
	}

	@Override
	public Long findSpecifyRemaining(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		paramMap.put("appId", appId);
		return getSqlSession().selectOne("findSpecifyRemaining", paramMap);
	}

	@Override
	public List<Long> findNOSpecify4App(Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		return getSqlSession().selectList("findNOSpecify4App", paramMap);
	}

	@Override
	public List<Long> findNOSpecify4AppNew(Long appId, Date newItemTime) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		paramMap.put("newItemTime", newItemTime);
		return getSqlSession().selectList("findNOSpecify4AppNew", paramMap);
	}

	@Override
	public ItemAppSpecifyEntity findByItemIdAndAppId(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		paramMap.put("appId", appId);
		return getSqlSession().selectOne("findByItemIdAndAppId", paramMap);
	}

	@Override
	public ItemAppSpecifyEntity findByItemIdAndAppIdLock(Long itemId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		paramMap.put("appId", appId);
		return getSqlSession().selectOne("findByItemIdAndAppIdLock", paramMap);
	}

	@Override
	public void insert(ItemAppSpecifyEntity ItemAppSpecifyEntity) {
		getSqlSession().insert("insert", ItemAppSpecifyEntity);
	}

	@Override
	public ItemAppSpecifyEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return getSqlSession().selectOne("find", paramMap);
	}

	@Override
	public void updateRemaining(Long id, Integer remaining) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("remaining", remaining);
		getSqlSession().update("updateRemaining", paramMap);
	}

	@Override
	public List<Long> findItemSpecify(Long appId) {
		Map<String, Object> queryMap = new HashMap<String, Object>();
		queryMap.put("appId", appId);
		return getSqlSession().selectList("findItemSpecify", queryMap);
	}
}
