package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAutoRecommendDao;

@Repository
public class ItemAutoRecommendDaoImpl extends BaseCreditsDao implements ItemAutoRecommendDao {

	@Override
	public List<Long> findItemAutoRecommendNoSpecify(Boolean autoRecommend, Boolean enable) {
		Map<String, Object> queryMap = new HashMap<String, Object>();
		queryMap.put("autoRecommend", autoRecommend);
		queryMap.put("enable", enable);
		return getSqlSession().selectList(getStamentNameSpace("findItemAutoRecommendNoSpecify"), queryMap);
	}

	@Override
	public List<Long> findItemAppTagsMasking(Long appId) {
		Map<String, Object> queryMap = new HashMap<String, Object>();
		queryMap.put("appId", appId);
		return getSqlSession().selectList(getStamentNameSpace("findItemAppTagsMasking"), queryMap);
	}

	@Override
	public List<Long> findItemInApp(Long appId, Boolean isOwner, Boolean deleted) {
		Map<String, Object> queryMap = new HashMap<String, Object>();
		queryMap.put("appId", appId);
		queryMap.put("isOwner", isOwner);
		queryMap.put("deleted", deleted);
		return getSqlSession().selectList(getStamentNameSpace("findItemInApp"), queryMap);
	}

	@Override
	public List<Long> findItemSpecify(Long appId) {
		Map<String, Object> queryMap = new HashMap<String, Object>();
		queryMap.put("appId", appId);
		return getSqlSession().selectList(getStamentNameSpace("findItemSpecify"), queryMap);
	}

}
