package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemStockConsumeDao;
import cn.com.duiba.goods.center.biz.entity.ItemStockConsumeEntity;

@Repository
public class ItemStockConsumeDaoImpl extends BaseCreditsDao implements ItemStockConsumeDao {

	@Override
	public int insert(ItemStockConsumeEntity ItemStockConsumeEntity) {
		return getSqlSession().insert("insert", ItemStockConsumeEntity);
	}

	@Override
	public int countConsumeStockLock(Long relationId, String relationType, Date time) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("relationId", relationId);
		map.put("relationType", relationType);
		map.put("time", time);
		return getSqlSession().selectOne("countConsumeStockLock", map);
	}

	@Override
	public int countAppConsumeStockLock(Long relationId, String relationType, Long appId, Date time) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("relationId", relationId);
		map.put("relationType", relationType);
		map.put("appId", appId);
		map.put("time", time);
		return getSqlSession().selectOne("countAppConsumeStockLock", map);
	}

	@Override
	public ItemStockConsumeEntity findByBizIdAndSource(String bizId, String bizSource) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("bizId", bizId);
		map.put("bizSource", bizSource);
		return getSqlSession().selectOne("findByBizIdAndSource", map);
	}

}
