package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockConsumeDetailDao;
import cn.com.duiba.goods.center.biz.entity.PreStockConsumeDetailEntity;

@Repository
public class PreStockConsumeDetailDaoImpl extends BaseCreditsDao implements PreStockConsumeDetailDao {

	@Override
	public PreStockConsumeDetailEntity insert(PreStockConsumeDetailEntity detail) {
		int ret = getSqlSession().insert("insert", detail);
		if (ret == 1) {
			return detail;
		}
		return null;
	}

	@Override
	public PreStockConsumeDetailEntity find(Long id) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("id", id);
		return getSqlSession().selectOne("find", params);
	}

	@Override
	public Integer countSalesTimeByLock(Long pointId, Date startTime) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("pointId", pointId);
		params.put("startTime", startTime);
		Integer ret = getSqlSession().selectOne("countSalesTimeByLock", params);
		if (ret == null) {
			return 0;
		}
		return ret;
	}

	@Override
	public Integer countSalesTime(Long pointId, Date startTime) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("pointId", pointId);
		params.put("startTime", startTime);
		Integer ret = getSqlSession().selectOne("countSalesTime", params);
		if (ret == null) {
			return 0;
		}
		return ret;
	}

	@Override
	public PreStockConsumeDetailEntity findByBizIdAndPayAction(String bizId) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("bizId", bizId);
		return getSqlSession().selectOne("findByBizIdAndPayAction", params);
	}

	@Override
	public Integer countSales(Long pointId) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("pointId", pointId);
		Integer ret = getSqlSession().selectOne("countSales", params);
		if (ret == null) {
			return 0;
		}
		return ret;
	}
}
