package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockManualChangeDao;
import cn.com.duiba.goods.center.biz.entity.PreStockManualChangeEntity;

@Repository
public class PreStockManualChangeDaoImpl extends BaseCreditsDao implements PreStockManualChangeDao {

	@Override
	public PreStockManualChangeEntity insert(PreStockManualChangeEntity instance) {
		int ret = getSqlSession().insert("insert", instance);
		if (ret == 1) {
			return instance;
		}
		return null;
	}

	@Override
	public PreStockManualChangeEntity find(Long id) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("id", id);
		return getSqlSession().selectOne("find", params);
	}

	@Override
	public PreStockManualChangeEntity findByStockIdAndBizId(Long stockId, Long bizId) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("stockId", stockId);
		params.put("bizId", bizId);
		return getSqlSession().selectOne("findByStockIdAndBizId", params);
	}
}
