package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockPointDao;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;

@Repository
public class PreStockPointDaoImpl extends BaseCreditsDao implements PreStockPointDao {

	@Override
	public List<PreStockPointEntity> findAllByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		return getSqlSession().selectList("findAllByItemId", paramMap);
	}

	@Override
	public void batchInsert(List<PreStockPointEntity> prePointList) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("stockPointList", prePointList);
		getSqlSession().insert("batchInsert", paramMap);
	}

	@Override
	public List<Long> findAllAppIdByItemId(Long itemId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		return getSqlSession().selectList("findAllAppIdByItemId", paramMap);
	}

	@Override
	public PreStockPointEntity findAppIdAndItemId(Long appId, Long itemId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		paramMap.put("appId", appId);
		return getSqlSession().selectOne("findAppIdAndItemId", paramMap);
	}

	@Override
	public PreStockPointEntity findItemIdAndNullApp(Long itemId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		return getSqlSession().selectOne("findItemIdAndNullApp", paramMap);
	}

	@Override
	public void udpate(PreStockPointEntity point) {
		getSqlSession().update("update", point);
	}

	@Override
	public int insert(PreStockPointEntity pointStock) {
		return getSqlSession().insert("insert", pointStock);
	}

	@Override
	public List<PreStockPointEntity> findAllPointAppItem(List<Long> itemIds, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemIds", itemIds);
		paramMap.put("appId", appId);
		return getSqlSession().selectList("findAllPointAppItem", paramMap);
	}

	@Override
	public PreStockPointEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return getSqlSession().selectOne("find", paramMap);
	}

}
