package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by gyf .
 * 16/10/19 .
 */
@Service("remoteGoodsLimitRecordService")
public class RemoteGoodsLimitRecordServiceImpl implements RemoteGoodsLimitRecordService {

    private static Logger LOGGER = LoggerFactory.getLogger(RemoteGoodsLimitRecordServiceImpl.class);

    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;

    @Override
    public DubboResult<Integer> findCount(int gtype, long gid, long consumerId) {
        try {
            Integer result = goodsLimitRecordService.findCount(gtype, gid, consumerId);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("findCount ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> addRecord(int gtype, long gid, long consumerId) {
        try {
            goodsLimitRecordService.addRecord(gtype, gid, consumerId);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOGGER.error("addRecord ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Void> rollbackRecord(int gtype, long gid, long consumerId) {
        try {
            goodsLimitRecordService.rollbackRecord(gtype, gid, consumerId);
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOGGER.error("rollbackRecord ", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
