package cn.com.duiba.goods.center.biz.service;

import cn.com.duiba.goods.center.biz.entity.GoodsTagsEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import java.util.List;
import java.util.Map;

public interface GoodsTagsService {

    /**
     * 创建/编辑,平台券 tags
     *
     * @param pcgId the pcg id
     * @param tags  the tags
     * @return the boolean
     */
    boolean savePCGTags(Long pcgId, String tags);

    /**
     * 查询.
     *
     * @param gtype the gtype
     * @param gid   the gid
     * @return the GoodsTagsEntity
     */
    GoodsTagsEntity selectByGidAndGtype(Integer gtype,Long gid);


    /**
     * 根据 pcgIds 获取标签数组
     *
     * @param pcgIds the pcg ids
     * @return the list
     */
    List<GoodsTagsEntity> findByPCGIds(List<Long> pcgIds);

    /**
     * 根据 pcgEntitis 获取他们的 ids
     *
     * @param pcgs the pcgs
     * @return the pcg ids by entities
     */
    List<Long> getPCGIdsByEntities(List<PlatformCouponGoodsEntity> pcgs);


    /**
     * 废弃原因:返回Long->String String拆解成List 匹配效率没有Set做交集运算高
     * 建议使用 Multimap<String,String> getPCGTagsMap(List<Long> pcgIds)
     * @param pcgs
     * @return
     */
    @Deprecated
    Map<Long, String> getPCGTagsMapByEntities(List<PlatformCouponGoodsEntity> pcgs);

    /**
     * 废弃原因同上
     * 获取 pcg tags map
     * @param pcgIds
     * @return
     */
    @Deprecated
    Map<Long, String> getPCGTagsMapByIds(List<Long> pcgIds);

    /**
     * 获取平台券的标记   们!
     * @param pcgIds
     * @return HashMultimap  相当于(Long -> Set<String>)
     */
    HashMultimap<Long,String> getPCGTagsMap(List<Long> pcgIds);

    /**
     * 包含了标签,需要拦截
     * @param pcgId
     * @param appId
     * @return
     */
    boolean containsAppTag(Long pcgId, Long appId);

    /**
     * 根据 appId 获取tags
     * @param appId
     * @return
     */
    List<String> getAppTags(Long appId);
}
