package cn.com.duiba.goods.center.biz.service;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGCategorySellerGoodsDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGFilterConfigDto;
import cn.com.duiba.goods.center.biz.bo.impl.PCGFilterConfigBOImpl;
import cn.com.duiba.goods.center.biz.entity.PCGCategoryEntity;
import cn.com.duiba.goods.center.biz.entity.PCGFilterConfigEntity;
import cn.com.duiba.goods.center.biz.entity.PCGSellerEntity;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName:PCGFilterConfigService <br/>
 * Date:     2016年6月13日 下午12:23:22 <br/>
 * @author   zhengjy
 * @version
 * @since    JDK 1.6
 * @see
 */
public interface PCGFilterConfigService {

	Long insert(long appId,int type,long targetId);

    int delete(long appId,int type,long targetId);

    PCGFilterConfigEntity select(Long id);

	/**
     * 查询app下屏蔽券列表
     * @author zhengjy
     * @param appId AppId
     * @return PlatformCouponGoodsEntity
     */
    public List<PlatformCouponGoodsEntity> findGoodsFilterList(Long appId);

    /**
     * 查询app下屏蔽分类列表
     * @author zhengjy
     * @param appId AppId
     * @return PCGCategoryEntity
     */
    public List<PCGCategoryEntity> findCategoryFilterList(Long appId);

    /**
     * 查询app下屏蔽品牌列表
     * @author zhengjy
     * @param appId AppId
     * @return PCGCategoryEntity
     */
    public List<PCGSellerEntity> findSellerFilterList(Long appId);

    /**
     * 查询券属于分类或品牌
     * @param goodsId  商品id
     * @return
     */
    public List<PCGFilterConfigDto> findCounponBelong(Long goodsId);

    /**
 	 * 查询所有分类未被屏蔽的券列表 <br/>
 	 * @author zhengjy
 	 * @param appId appId
 	 * @return
 	 */
    List<PCGCategorySellerGoodsDto> selectPCGCategoryGoodsList(Long appId);

    /**
     * 查询所有品牌未被屏蔽的券列表 <br/>
     * @author zhengjy
     * @param appId appId
     * @return
     */
    List<PCGCategorySellerGoodsDto> selectPCGSellerGoodsList(Long appId);

    /**
     * 查询app下屏蔽券列表 <br/>
     * @param appId AppId
     * @param type  1:优惠券 2:分类 3:品牌
     * @return
     */
     List<Long> selectPCGFilterTargetIds(Long appId,Integer type);

     /**
      * 查询平台券信息  包括按钮兑换状态 <br/>
      * @param appId
      * @param gid
      * @param consumerId
      * @param consumerCredits
      * @param type  1:优惠券 2:分类 3:品牌
      * @author   guoey
      * @return
      */
	PCGCategorySellerGoodsDto findSellerGoodsInfo(long appId, long gid,Long consumerId, Long consumerCredits) throws Exception;
	/**
	 * 批量查询券属于分类或品牌
	 * @param catSet
	 * @return
	 */
	Map<Long, List<PCGFilterConfigDto>> findFilterCounponBelongs(Set<Long> catSet,Set<Long> sellerSet);


    /**
     * 废弃原因:杜绝平级调用,appTags应该从web端参数传入
     *         在做过滤时,List 做交集的效率没有Set 高
     *         在过滤操作时,最好使用管道式的写法,有进有出,减少BUG率
     *
     * 推荐使用:goodsTagsFilter(List<PlatformCouponGoodsEntity> pcgs, String appTags)
     * 过滤标签库
     * @param pcgs
     * @param appId
     */
    @Deprecated
    void goodsTagsFilter(List<PlatformCouponGoodsEntity> pcgs, Long appId);

    /**
     * 废弃原因:原因同上
     * 过滤标签库
     * @param pcgIds
     * @param appId
     */
    @Deprecated
    void goodsTagsIdFilter(List<Long> pcgIds, Long appId);

    /**
     * 过滤标签库
     * @param pcgs
     * @param appTags app的标签,逗号分隔
     */
    List<PlatformCouponGoodsEntity> goodsTagsFilter(List<PlatformCouponGoodsEntity> pcgs, String appTags);
}
