/**
 * Project Name:goods-center-biz
 * File Name:PlatformCouponGoodsService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年5月27日下午1:09:34
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import cn.com.duiba.goods.center.api.remoteservice.dto.PCGEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.PCGInsertDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.goods.center.biz.entity.PlatformCouponGoodsEntity;

import java.util.List;
import java.util.Map;

/**
 * ClassName:PlatformCouponGoodsService <br/>
 * Date:     2016年5月27日 下午1:09:34 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface PlatformCouponGoodsService {

    public Long createPlatformCouponGoods(PCGInsertDto goods);
    
    public PlatformCouponGoodsEntity find(long pcgId);
    
    public PlatformCouponGoodsEntity findIncludeDeleted(long pcgId) ;

    public List<PlatformCouponGoodsEntity> findListByIds(List<Long> pcgIds);

    public Map<Long, PlatformCouponGoodsEntity> findByIds(List<Long> pcgIds);

    public void editPlatformCouponGoods(Long pcgId, PCGEditDto goods);
    /**
     * 更新商品的券类型
     *
     * @author xuhengfei
     * @param pcgId
     * @param couponType
     * @since JDK 1.6
     */
    public boolean editPlatformCouponType(Long pcgId,int couponType);

    public void onshelfGoods(Long pcgId);

    public void offshelfGoods(Long pcgId);

    public void deleteGoods(Long pcgId);

    public List<PlatformCouponGoodsEntity> searchByName(String name);
    
    public Page<PlatformCouponGoodsEntity> findPage(String name,Integer pcgStatus,int pageSize,int pageIndex);
    
    public void editPCGSwitches(Long pcgId,Long switches);
}

