package cn.com.duiba.goods.center.biz.service.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.entity.CouponBatchEntity;


/**
 * 优惠券内部流程 service
 */
public interface CouponFlowInnerService {

	/**
	 * <b>优惠券批次校验</b><br/>
	 * 
	 * 1.批次库存 > 0 <br/>
	 * 2.批次新建或使用中 <br/>
	 * 
	 * @param itemKey
	 * @return CouponBatchDO
	 * @throws Exception
	 */
	public CouponBatchEntity checkCouponBatch(ItemKeyDto itemKey);

	/**
	 * <b>取商品当前批次</b><br/>
	 * 1.如果是兑吧商品返回兑吧商品引用批次<br/>
	 * 2.如果是自有山炮返回自有商品应用批次<br/>
	 * 
	 * @param itemKey
	 * @return
	 * @throws Exception
	 */
	public CouponBatchEntity getItemKeyCurrentCouponBatch(ItemKeyDto itemKey);

	/**
	 * <b>ItemKey商品切换批次 </b><br/>
	 * 
	 * 0.开启事务<br/>
	 * 1.判断当前批次无效<br/>
	 * 2.批次过期置为失效 CouponBatchDO.ActiveOverdue <br/>
	 * 3.批次已使用且count优惠券有库存设置为新建 CouponBatchDO.ActiveNew <br/>
	 * 4.批次使用中且count优惠券无库存设置为已使用 <br/>
	 * 5.查询下一个批次 <br/>
	 * 6.根据下一个批次ID统计优惠券库存 <br/>
	 * 7.设置下一个批次为使用中CouponBatchDO.ActiveUsing <br/>
	 * 9.修改兑换项批次引用ID <br/>
	 * 10.提交事务
	 * 
	 * @param itemKey
	 * @throws Exception
	 */
	public void switchBatch(ItemKeyDto itemKey);

	/**
	 * <b>兑吧商品切换批次 </b><br/>
	 * 
	 * 0.开启事务<br/>
	 * 1.判断当前批次无效<br/>
	 * 2.批次过期置为失效 CouponBatchDO.ActiveOverdue <br/>
	 * 3.批次已使用且count优惠券有库存设置为新建 CouponBatchDO.ActiveNew <br/>
	 * 4.批次使用中且count优惠券无库存设置为已使用 <br/>
	 * 5.查询下一个批次 <br/>
	 * 6.根据下一个批次ID统计优惠券库存 <br/>
	 * 7.设置下一个批次为使用中CouponBatchDO.ActiveUsing <br/>
	 * 9.修改兑换项批次引用ID <br/>
	 * 10.提交事务
	 * 
	 * @param itemKey
	 * @throws Exception
	 */
	public void switchItemBatch(long itemId);

	/**
	 * <b>自有商品切换批次 </b><br/>
	 * 
	 * 0.开启事务<br/>
	 * 1.判断当前批次无效<br/>
	 * 2.批次过期置为失效 CouponBatchDO.ActiveOverdue <br/>
	 * 3.批次已使用且count优惠券有库存设置为新建 CouponBatchDO.ActiveNew <br/>
	 * 4.批次使用中且count优惠券无库存设置为已使用 <br/>
	 * 5.查询下一个批次 <br/>
	 * 6.根据下一个批次ID统计优惠券库存 <br/>
	 * 7.设置下一个批次为使用中CouponBatchDO.ActiveUsing <br/>
	 * 9.修改兑换项批次引用ID <br/>
	 * 10.提交事务
	 * 
	 * @param itemKey
	 * @throws Exception
	 */
	public void switchAppItemBatch(long appItemId) ;

	/**
	 * <b>刷新商品ItemKey优惠券信息 </b><br/>
	 * 
	 * 1.更新兑换项库存 <br/>
	 * 2.更新兑换项过期时间 <br/>
	 * 
	 * @param itemKey
	 * @throws Exception
	 */
	public void refreshItemKeyCoupon(ItemKeyDto itemKey) ;

	/**
	 * <b>刷新兑吧商品优惠券信息 </b><br/>
	 * 
	 * 1.更新兑换项库存 <br/>
	 * 2.更新兑换项过期时间 <br/>
	 * 
	 * @param itemKey
	 * @throws Exception
	 */
	public void refreshItemCoupon(long itemId);

	/**
	 * <b>刷新自有商品优惠券信息 </b><br/>
	 * 
	 * 1.更新兑换项库存 <br/>
	 * 2.更新兑换项过期时间 <br/>
	 * 
	 * @param itemKey
	 * @throws Exception
	 */
	public void refreshAppItemCoupon(long appItemId);

	/**
	 * <b>刷新批次信息 </b><br/>
	 * 1.判断是否过期<br/>
	 * 2.统计批次优惠券可用库存<br/>
	 * 3.如果批次有可用库存且批次为已使用，修改为新建<br/>
	 * 4.如果没库存修改为已使用
	 */
	public void refreshBatch(CouponBatchEntity couponBatchDO) ;
	
}
