package cn.com.duiba.goods.center.biz.service.item;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;
import cn.com.duiba.goods.center.common.GoodsException;

public interface PreStockService {

	/**
	 * 扣库存
	 * @param bizId
	 * @param appId
	 * @param pointId
	 * @throws BusinessException
	 * @throws StatusException
	 */
    public void consumeStock(String bizId,Long appId, Long pointId) throws GoodsException;

    /**
     * 返还库存
     * @param bizId
     * @throws BusinessException
     */
    public void paybackStock(String bizId) throws GoodsException;

    /**
     * 查询库存预分配的库存
     * 为null则最兑换项本身的
     */
    public Long getPreStock(ItemEntity itemEntity, Long appId);

    /**
     * 获取销售数量
     * @param itemKey
     * @return
     */
    public Integer getPreStockQuantitySales(ItemKeyDto itemKey);

    /**
     * 判断是否是兑吧库存预分配
     * @return
     */
    public PreStockPointEntity getPointStock(ItemEntity itemEntity, Long appId);

    /**
     * 新建一个库存
     * @param relationType
     * @param relationId
     * @return
     */
    public long newStock(Long pointId,Long stock) throws GoodsException;
    
    /**
     * 添加库存
     * @param relationType
     * @param relationId
     * @param stock
     * @return
     */
    public boolean addStockQuantity(Long bizId,Long pointId,Integer quantity) throws GoodsException;
    /**
     * 减少库存
     * @param relationType
     * @param relationId
     * @param stock
     * @return
     */
    public boolean reduceStockQuantity(Long bizId,Long pointId,Integer quantity) throws GoodsException;
    
    /**
     * 清理预分配库存缓存
     * @param pointId
     * @return
     */
    public Boolean deletePreStockCounter(Long pointId);

    /**
     * 减去所有
     * @param bizId
     * @param pointId
     * @return
     * @throws Exception
     */
    public boolean reduceStockAll(Long bizId,Long pointId) throws GoodsException;

    /**
     * 保存预分配库存
     * @param insertPointList
     * @param updatePointList
     * @throws BusinessException
     */
    public void submitPreStock(List<PreStockPointEntity> insertPointList, List<PreStockPointEntity> updatePointList) throws GoodsException;
}
